/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Timed;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTimeTool
extends Tool {
    private Timed timed;
    private long newTime;
    private long oldTime;

    public ChangeTimeTool(Timed timed, long l) {
        this.timed = timed;
        this.newTime = l;
        this.oldTime = timed.getTime();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeTimeTool) {
            ChangeTimeTool changeTimeTool = (ChangeTimeTool)tool;
            if (changeTimeTool.timed == this.timed) {
                this.newTime = changeTimeTool.newTime;
                this.timeStamp = changeTimeTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newTime == this.oldTime) {
            return false;
        }
        this.timed.setTime(this.newTime);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.timed.setTime(this.newTime);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.timed.setTime(this.oldTime);
        Controller.getInstance().updatePanel();
        return true;
    }
}

