/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeSlidesTool
extends Tool {
    private Animation animation;
    private boolean newSlides;
    private boolean oldSlides;

    public ChangeSlidesTool(Animation animation, boolean bl) {
        this.animation = animation;
        this.newSlides = bl;
        this.oldSlides = animation.isSlides();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newSlides == this.oldSlides) {
            return false;
        }
        this.animation.setSlides(this.newSlides);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.animation.setSlides(this.newSlides);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.animation.setSlides(this.oldSlides);
        Controller.getInstance().updatePanel();
        return true;
    }
}

