/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeImageURITool
extends Tool {
    private Frame frame;
    private String newUri;
    private String oldUri;

    public ChangeImageURITool(Frame frame, String string) {
        this.frame = frame;
        this.newUri = string;
        this.oldUri = frame.getUri();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeImageURITool) {
            ChangeImageURITool changeImageURITool = (ChangeImageURITool)tool;
            if (changeImageURITool.frame == this.frame) {
                this.newUri = changeImageURITool.newUri;
                this.timeStamp = changeImageURITool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newUri == this.oldUri) {
            return false;
        }
        this.frame.setUri(this.newUri);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.frame.setUri(this.newUri);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.frame.setUri(this.oldUri);
        Controller.getInstance().updatePanel();
        return true;
    }
}

