/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeAssessmentProfileTypeTool
extends Tool {
    public static final int NORMAL = 0;
    public static final int SCORM12 = 1;
    public static final int SCORM2004 = 2;
    private int type;
    private AssessmentProfile assessProfile;
    private int oldType;

    public ChangeAssessmentProfileTypeTool(AssessmentProfile assessmentProfile, int n, boolean bl, boolean bl2) {
        this.type = n;
        this.assessProfile = assessmentProfile;
        if (!bl && !bl2) {
            this.oldType = 0;
        } else if (bl && !bl2) {
            this.oldType = 1;
        } else if (!bl && bl2) {
            this.oldType = 2;
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.type == 0) {
            this.assessProfile.changeToNormalProfile();
        } else if (this.type == 1) {
            this.assessProfile.changeToScorm12Profile();
        } else if (this.type == 2) {
            this.assessProfile.changeToScorm2004Profile();
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean redoTool() {
        this.doTool();
        return true;
    }

    @Override
    public boolean undoTool() {
        if (this.oldType == 0) {
            this.assessProfile.changeToNormalProfile();
        } else if (this.oldType == 1) {
            this.assessProfile.changeToScorm12Profile();
        } else if (this.oldType == 2) {
            this.assessProfile.changeToScorm2004Profile();
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

