/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.animation.AnimationDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.TransitionDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.assetchooser.AssetChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AddNewFrameTool
extends Tool {
    private AnimationDataControl animationDataControl;
    private int index;
    private Frame newFrame;
    private FrameDataControl newFrameDataControl;
    private Animation animation;
    private Transition newTransition;
    private TransitionDataControl newTransitionDataControl;
    private List<Frame> newFrameList;
    private List<FrameDataControl> newFrameDataControlList;
    private List<Transition> newTransitionList;
    private List<TransitionDataControl> newTransitionDataControlList;

    public AddNewFrameTool(AnimationDataControl animationDataControl, int n, Frame frame) {
        this.animationDataControl = animationDataControl;
        this.index = n;
        this.newFrame = frame;
        if (frame == null) {
            frame = new Frame(animationDataControl.getImageLoaderFactory());
        }
        this.animation = (Animation)animationDataControl.getContent();
        this.newFrameDataControl = new FrameDataControl(frame);
        this.newTransition = new Transition();
        this.newTransitionDataControl = new TransitionDataControl(this.newTransition);
        this.newFrameList = new ArrayList<Frame>();
        this.newTransitionList = new ArrayList<Transition>();
        this.newFrameDataControlList = new ArrayList<FrameDataControl>();
        this.newTransitionDataControlList = new ArrayList<TransitionDataControl>();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        int n;
        Object var1_1 = null;
        File[] fileArray = null;
        AssetChooser assetChooser = AssetsController.getAssetChooser(2, 0);
        assetChooser.setMultiSelectionEnabled(true);
        Object[] objectArray = null;
        String[] stringArray = null;
        int n2 = assetChooser.showAssetChooser(Controller.getInstance().peekWindow());
        if (n2 == 4) {
            objectArray = assetChooser.getSelectedAssets();
            stringArray = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                stringArray[n] = AssetsController.getCategoryFolder(2) + "/" + objectArray[n].toString();
            }
        } else if (n2 == 5) {
            fileArray = assetChooser.getSelectedFiles();
            stringArray = new String[fileArray.length];
            for (n = 0; n < fileArray.length; ++n) {
                stringArray[n] = AssetsController.getCategoryFolder(8) + "/" + fileArray[n].getName();
                AssetsController.addSingleAsset(8, fileArray[n].getAbsolutePath());
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            Frame frame = new Frame(this.animationDataControl.getImageLoaderFactory());
            FrameDataControl frameDataControl = new FrameDataControl(frame);
            Transition transition = new Transition();
            TransitionDataControl transitionDataControl = new TransitionDataControl(transition);
            frame.setUri(stringArray[n]);
            if (this.index >= this.animationDataControl.getFrameCount() || this.index < 0) {
                this.index = this.animationDataControl.getFrameCount() - 1;
            }
            this.animation.getFrames().add(this.index + n + 1, frame);
            this.animation.getTransitions().add(this.index + n + 2, transition);
            this.animationDataControl.getFrameDataControls().add(this.index + n + 1, frameDataControl);
            this.animationDataControl.getTransitionDataControls().add(this.index + n + 2, transitionDataControl);
            this.newFrameList.add(frame);
            this.newFrameDataControlList.add(frameDataControl);
            this.newTransitionList.add(transition);
            this.newTransitionDataControlList.add(transitionDataControl);
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        this.animation.getFrames().add(this.index + 1, this.newFrame);
        this.animation.getTransitions().add(this.index + 2, this.newTransition);
        this.animationDataControl.getFrameDataControls().add(this.index + 1, this.newFrameDataControl);
        this.animationDataControl.getTransitionDataControls().add(this.index + 2, this.newTransitionDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.animation.getFrames().remove(this.newFrame);
        this.animation.getTransitions().remove(this.newTransition);
        this.animationDataControl.getFrameDataControls().remove(this.newFrameDataControl);
        this.animationDataControl.getTransitionDataControls().remove(this.newTransitionDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

