/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class MoveRuleTool
extends Tool {
    public static final int MODE_UP = 0;
    public static final int MODE_DOWN = 1;
    private DataControl dataControl;
    private int mode;
    private AdaptationProfileDataControl adaptDataControl;

    public MoveRuleTool(AdaptationProfileDataControl adaptationProfileDataControl, DataControl dataControl, int n) {
        this.adaptDataControl = adaptationProfileDataControl;
        this.dataControl = dataControl;
        this.mode = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (this.mode == 0) {
            return this.adaptDataControl.moveElementUp(this.dataControl);
        }
        if (this.mode == 1) {
            return this.adaptDataControl.moveElementDown(this.dataControl);
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            bl = this.adaptDataControl.moveElementUp(this.dataControl);
        } else if (this.mode == 1) {
            bl = this.adaptDataControl.moveElementDown(this.dataControl);
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            bl = this.adaptDataControl.moveElementDown(this.dataControl);
        } else if (this.mode == 1) {
            bl = this.adaptDataControl.moveElementUp(this.dataControl);
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

