/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteUOLPropertyTool
extends Tool {
    protected UOLProperty propertyDeleted;
    protected AdaptationRule parent;
    protected int index;

    public DeleteUOLPropertyTool(AdaptationRule adaptationRule, int n) {
        this.parent = adaptationRule;
        this.index = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.index >= 0 && this.index < this.parent.getUOLProperties().size()) {
            this.propertyDeleted = (UOLProperty)this.parent.getUOLProperties().remove(this.index);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.parent.getUOLProperties().remove(this.index);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parent.getUOLProperties().add(this.index, this.propertyDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }
}

