/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class DeleteRuleTool
extends Tool {
    protected DataControl dataControl;
    protected List<AdaptationRuleDataControl> oldAdapRules;
    protected List<AssessmentRuleDataControl> oldAssessRules;
    protected int type;
    protected int index;

    public DeleteRuleTool(DataControl dataControl, int n, int n2) {
        this.dataControl = dataControl;
        this.type = n;
        this.index = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.canBeDeleted()) {
            if (this.type == 39) {
                this.oldAdapRules = new ArrayList<AdaptationRuleDataControl>(((AdaptationProfileDataControl)this.dataControl).getDataControls());
                return this.dataControl.deleteElement(((AdaptationProfileDataControl)this.dataControl).getAdaptationRules().get(this.index), true);
            }
            if (this.type == 38 || this.type == 49) {
                this.oldAssessRules = new ArrayList<AssessmentRuleDataControl>(((AssessmentProfileDataControl)this.dataControl).getDataControls());
                return this.dataControl.deleteElement(((AssessmentProfileDataControl)this.dataControl).getAssessmentRules().get(this.index), true);
            }
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.dataControl.canBeDeleted()) {
            if (this.type == 39) {
                if (this.dataControl.deleteElement(((AdaptationProfileDataControl)this.dataControl).getAdaptationRules().get(this.index), true)) {
                    Controller.getInstance().updatePanel();
                    return true;
                }
                return false;
            }
            if (this.type == 38) {
                if (this.dataControl.deleteElement(((AssessmentProfileDataControl)this.dataControl).getAssessmentRules().get(this.index), true)) {
                    Controller.getInstance().updatePanel();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.type == 39) {
            ((AdaptationProfileDataControl)this.dataControl).setDataControlsAndData(new ArrayList<AdaptationRuleDataControl>(this.oldAdapRules));
            Controller.getInstance().getIdentifierSummary().addAdaptationRuleId(this.oldAdapRules.get(this.index).getId(), ((AdaptationProfileDataControl)this.dataControl).getName());
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.type == 38 || this.type == 49) {
            ((AssessmentProfileDataControl)this.dataControl).setDataControlsAndData(new ArrayList<AssessmentRuleDataControl>(this.oldAssessRules));
            Controller.getInstance().getIdentifierSummary().addAssessmentRuleId(this.oldAssessRules.get(this.index).getId(), ((AssessmentProfileDataControl)this.dataControl).getName());
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }
}

