/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeUOLPropertyTool
extends Tool {
    public static final int SET_ID = 2;
    public static final int SET_VALUE = 3;
    public static final int SET_OP = 4;
    protected UOLProperty oldProperty;
    protected UOLProperty newProperty;
    protected AdaptationRule parent;
    protected int mode;
    protected int index;

    public ChangeUOLPropertyTool(AdaptationRule adaptationRule, String string, int n, int n2) {
        this.mode = n2;
        this.oldProperty = (UOLProperty)adaptationRule.getUOLProperties().get(n);
        this.parent = adaptationRule;
        this.index = n;
        if (n2 == 2) {
            this.newProperty = new UOLProperty(string, this.oldProperty.getValue(), this.oldProperty.getOperation());
        } else if (n2 == 3) {
            this.newProperty = new UOLProperty(this.oldProperty.getId(), string, this.oldProperty.getOperation());
        } else if (n2 == 4) {
            this.newProperty = new UOLProperty(this.oldProperty.getId(), this.oldProperty.getValue(), string);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.mode == 2 || this.mode == 3 || this.mode == 4;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.mode == 2 || this.mode == 3 || this.mode == 4) {
            if (this.index >= 0 && this.index < this.parent.getUOLProperties().size()) {
                this.parent.getUOLProperties().remove(this.index);
                this.parent.getUOLProperties().add(this.index, this.newProperty);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.mode == 2 || this.mode == 3 || this.mode == 4) {
            this.parent.getUOLProperties().remove(this.index);
            this.parent.getUOLProperties().add(this.index, this.newProperty);
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.mode == 2 || this.mode == 3 || this.mode == 4) {
            this.parent.getUOLProperties().remove(this.index);
            this.parent.getUOLProperties().add(this.index, this.oldProperty);
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }
}

