/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeAdaptationProfileTypeTool
extends Tool {
    public static final int NORMAL = 0;
    public static final int SCORM12 = 1;
    public static final int SCORM2004 = 2;
    private int type;
    private AdaptationProfile adapProfile;
    private int oldType;

    public ChangeAdaptationProfileTypeTool(AdaptationProfile adaptationProfile, int n, boolean bl, boolean bl2) {
        this.type = n;
        this.adapProfile = adaptationProfile;
        if (!bl && !bl2) {
            this.oldType = 0;
        } else if (bl && !bl2) {
            this.oldType = 1;
        } else if (!bl && bl2) {
            this.oldType = 2;
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.type == 0) {
            this.adapProfile.changeToNormalProfile();
        } else if (this.type == 1) {
            this.adapProfile.changeToScorm12Profile();
        } else if (this.type == 2) {
            this.adapProfile.changeToScorm2004Profile();
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        this.doTool();
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        if (this.oldType == 0) {
            this.adapProfile.changeToNormalProfile();
        } else if (this.oldType == 1) {
            this.adapProfile.changeToScorm12Profile();
        } else if (this.oldType == 2) {
            this.adapProfile.changeToScorm2004Profile();
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

