/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.ContainsAdaptedState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeActionTool
extends Tool {
    public static final int SET_ID = 2;
    public static final int SET_VALUE = 3;
    protected ContainsAdaptedState containsAS;
    protected AdaptedState state;
    protected AdaptedState oldState;
    protected int index;
    protected int mode;
    protected String newValue;

    public ChangeActionTool(ContainsAdaptedState containsAdaptedState, int n, String string, int n2) {
        this.containsAS = containsAdaptedState;
        this.state = containsAdaptedState.getAdaptedState();
        this.index = n;
        this.newValue = string;
        this.mode = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldState != null && (this.mode == 2 || this.mode == 3);
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.index >= 0 && this.index < this.state.getFlagsVars().size()) {
            try {
                this.oldState = (AdaptedState)this.state.clone();
                if (this.mode == 2) {
                    if (!this.state.getFlagVar(this.index).equals(this.newValue)) {
                        this.state.changeFlag(this.index, this.newValue);
                        bl = true;
                    }
                } else if (this.mode == 3 && !this.state.getAction(this.index).equals(this.newValue)) {
                    this.state.changeAction(this.index, this.newValue);
                    bl = true;
                }
                if (bl) {
                    Controller.getInstance().updateVarFlagSummary();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)("Could not clone adaptedState " + (this.state == null ? "null" : this.state.getClass().toString())));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Adaptation.ErrorNoFlags.Title"), TC.get((String)"Adaptation.ErrorNoFlags"));
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        return this.undoTool();
    }

    @Override
    public boolean undoTool() {
        try {
            AdaptedState adaptedState = (AdaptedState)this.state.clone();
            this.state.setTargetId(this.oldState.getTargetId());
            this.state.getFlagsVars().clear();
            for (String string : this.oldState.getFlagsVars()) {
                this.state.getFlagsVars().add(string);
            }
            this.state.getActionsValues().clear();
            for (String string : this.oldState.getActionsValues()) {
                this.state.getActionsValues().add(string);
            }
            this.oldState = adaptedState;
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)("Could not clone adaptedState " + (this.state == null ? "null" : this.state.getClass().toString())));
            return false;
        }
    }
}

