/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class AddRuleTool
extends Tool {
    protected DataControl dataControl;
    protected List<AdaptationRuleDataControl> oldAdapRules;
    protected List<AssessmentRuleDataControl> oldAssessRules;
    protected String ruleId;
    protected DataControl newDataControl;
    protected int type;

    public AddRuleTool(DataControl dataControl, int n) {
        this.dataControl = dataControl;
        this.type = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.canAddElement(this.type)) {
            String string = this.dataControl.getDefaultId(this.type);
            int n = 0;
            if (this.type == 39) {
                this.oldAdapRules = new ArrayList<AdaptationRuleDataControl>(((AdaptationProfileDataControl)this.dataControl).getDataControls());
                this.ruleId = ((AdaptationProfileDataControl)this.dataControl).getName() + "." + string;
                while (!Controller.getInstance().isElementIdValid(this.ruleId, false)) {
                    this.ruleId = ((AdaptationProfileDataControl)this.dataControl).getName() + "." + string + ++n;
                }
                this.ruleId = this.ruleId.substring(((AdaptationProfileDataControl)this.dataControl).getName().length() + 1);
            } else if (this.type == 38 || this.type == 49) {
                this.oldAssessRules = new ArrayList<AssessmentRuleDataControl>(((AssessmentProfileDataControl)this.dataControl).getDataControls());
                this.ruleId = ((AssessmentProfileDataControl)this.dataControl).getName() + "." + string;
                while (!Controller.getInstance().isElementIdValid(this.ruleId, false)) {
                    this.ruleId = ((AssessmentProfileDataControl)this.dataControl).getName() + "." + string + ++n;
                }
                this.ruleId = this.ruleId.substring(((AssessmentProfileDataControl)this.dataControl).getName().length() + 1);
            }
            boolean bl = this.dataControl.addElement(this.type, this.ruleId);
            if (this.type == 39) {
                this.newDataControl = ((AdaptationProfileDataControl)this.dataControl).getLastDatacontrol();
            } else if (this.type == 38 || this.type == 49) {
                this.newDataControl = ((AssessmentProfileDataControl)this.dataControl).getLastDatacontrol();
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.dataControl.canAddElement(this.type)) {
            String string;
            String string2 = string = this.dataControl.getDefaultId(this.type);
            int n = 0;
            while (!Controller.getInstance().isElementIdValid(string2, false)) {
                string2 = string + ++n;
            }
            boolean bl = false;
            if (this.type == 39) {
                bl = ((AdaptationProfileDataControl)this.dataControl).addElement(this.type, string2, (AdaptationRule)this.newDataControl.getContent());
            }
            if (this.type == 38 || this.type == 49) {
                bl = ((AssessmentProfileDataControl)this.dataControl).addElement(this.type, string2, (AssessmentRule)this.newDataControl.getContent());
            }
            if (bl) {
                Controller.getInstance().updatePanel();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.type == 39) {
            ((AdaptationProfileDataControl)this.dataControl).setDataControlsAndData(new ArrayList<AdaptationRuleDataControl>(this.oldAdapRules));
            Controller.getInstance().getIdentifierSummary().deleteAdaptationRuleId(this.ruleId, ((AdaptationProfileDataControl)this.dataControl).getName());
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.type == 38 || this.type == 49) {
            ((AssessmentProfileDataControl)this.dataControl).setDataControlsAndData(new ArrayList<AssessmentRuleDataControl>(this.oldAssessRules));
            Controller.getInstance().getIdentifierSummary().deleteAssessmentRuleId(this.ruleId, ((AssessmentProfileDataControl)this.dataControl).getName());
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }
}

