/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.adaptation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddActionTool
extends Tool {
    protected AdaptedState state;
    protected AdaptedState oldState;
    protected int index;
    protected int mode;

    public AddActionTool(AdaptedState adaptedState, int n) {
        this.state = adaptedState;
        this.index = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldState != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        String[] stringArray = Controller.getInstance().getVarFlagSummary().getFlags();
        if (stringArray != null) {
            try {
                this.oldState = (AdaptedState)this.state.clone();
                if (stringArray.length == 0) {
                    this.state.addActivatedFlag("flag");
                } else {
                    this.state.addActivatedFlag(stringArray[0]);
                    Controller.getInstance().updateVarFlagSummary();
                }
                bl = true;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)("Could not clone adaptedState " + (this.state == null ? "null" : this.state.getClass().toString())));
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        return this.undoTool();
    }

    @Override
    public boolean undoTool() {
        try {
            AdaptedState adaptedState = (AdaptedState)this.state.clone();
            this.state.setTargetId(this.oldState.getTargetId());
            this.state.getFlagsVars().clear();
            for (String string : this.oldState.getFlagsVars()) {
                this.state.getFlagsVars().add(string);
            }
            this.state.getActionsValues().clear();
            for (String string : this.oldState.getActionsValues()) {
                this.state.getActionsValues().add(string);
            }
            this.oldState = adaptedState;
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)("Could not clone adaptedState " + (this.state == null ? "null" : this.state.getClass().toString())));
            return false;
        }
    }
}

