/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.security.jarsigner;

import es.eucm.eadventure.editor.control.security.jarsigner.JSParameters;
import es.eucm.eadventure.editor.control.security.jarsigner.JarBASE64Encoder;
import es.eucm.eadventure.editor.control.security.jarsigner.JarSignerException;
import es.eucm.eadventure.editor.control.security.jarsigner.JarSignerParameters;
import es.eucm.eadventure.editor.control.security.jarsigner.TimestampedSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ManifestDigester;
import sun.security.x509.NetscapeCertTypeExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

class SignatureFile {
    Manifest sf;
    String baseName;

    public SignatureFile(MessageDigest[] messageDigestArray, Manifest manifest, ManifestDigester manifestDigester, String string, boolean bl) {
        ManifestDigester.Entry entry;
        this.baseName = string;
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        this.sf = new Manifest();
        Attributes attributes = this.sf.getMainAttributes();
        JarBASE64Encoder jarBASE64Encoder = new JarBASE64Encoder();
        attributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        attributes.putValue("Created-By", string2 + " (" + string3 + ")");
        if (bl) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-Manifest", jarBASE64Encoder.encode(manifestDigester.manifestDigest(messageDigestArray[i])));
            }
        }
        if ((entry = manifestDigester.get("Manifest-Main-Attributes", false)) != null) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-" + "Manifest-Main-Attributes", jarBASE64Encoder.encode(entry.digest(messageDigestArray[i])));
            }
        } else {
            throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
        }
        Map<String, Attributes> map = this.sf.getEntries();
        for (Map.Entry<String, Attributes> entry2 : manifest.getEntries().entrySet()) {
            String string4 = entry2.getKey();
            entry = manifestDigester.get(string4, false);
            if (entry == null) continue;
            Attributes attributes2 = new Attributes();
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes2.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", jarBASE64Encoder.encode(entry.digest(messageDigestArray[i])));
            }
            map.put(string4, attributes2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.sf.write(outputStream);
    }

    public String getMetaName() {
        return "META-INF/" + this.baseName + ".SF";
    }

    public String getBaseName() {
        return this.baseName;
    }

    void checkCertUsage(X509Certificate x509Certificate, boolean[] blArray) {
        Object object;
        boolean[] blArray2;
        if (blArray != null) {
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
        }
        if (!((blArray2 = x509Certificate.getKeyUsage()) == null || blArray2.length >= 1 && blArray2[0])) {
            if (blArray != null) {
                blArray[0] = true;
            } else {
                System.out.println("badkeyusage ERROR - The signer certificate's KeyUsage extension doesn't allow code signing.");
            }
        }
        try {
            object = x509Certificate.getExtendedKeyUsage();
            if (object != null && !object.contains("2.5.29.37.0") && !object.contains("1.3.6.1.5.5.7.3.3")) {
                if (blArray != null) {
                    blArray[1] = true;
                } else {
                    System.out.println("badExtendedKeyUsage ERROR - The signer certificate's ExtendedKeyUsage extension doesn't allow code signing. ");
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            certificateParsingException.printStackTrace();
        }
        try {
            object = x509Certificate.getExtensionValue("2.16.840.1.113730.1.1");
            if (object != null) {
                DerInputStream derInputStream = new DerInputStream((byte[])object);
                byte[] byArray = derInputStream.getOctetString();
                NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray = new DerValue(byArray).getUnalignedBitString().toByteArray());
                Boolean bl = (Boolean)netscapeCertTypeExtension.get("object_signing");
                if (!bl.booleanValue()) {
                    if (blArray != null) {
                        blArray[2] = true;
                    } else {
                        System.out.println("badNetscapeCertType ERROR - The signer certificate's NetscapeCertType extension doesn't allow code signing.");
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Block generateBlock(String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, TimestampedSigner timestampedSigner, JSParameters jSParameters, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException, UnrecoverableKeyException, KeyStoreException, JarSignerException {
        Object object;
        Object object2;
        long l = 15552000000L;
        Certificate[] certificateArray = null;
        try {
            certificateArray = jSParameters.getKeyStore().getCertificateChain(jSParameters.getAlias());
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (certificateArray == null) {
            MessageFormat messageFormat = new MessageFormat("Certificate chain not found for: alias.  alias must reference a valid KeyStore key entry containing a private key and corresponding public key certificate chain.");
            Object[] objectArray = new Object[]{jSParameters.getAlias(), jSParameters.getAlias()};
            throw new JarSignerException(messageFormat.format(objectArray));
        }
        x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            if (!(certificateArray[i] instanceof X509Certificate)) {
                throw new JarSignerException("found non-X.509 certificate in signer's chain");
            }
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        X509Certificate x509Certificate2 = (X509Certificate)jSParameters.getKeyStore().getCertificate(jSParameters.getAlias());
        try {
            x509Certificate2.checkValidity();
            if (x509Certificate2.getNotAfter().getTime() < System.currentTimeMillis() + l) {
                System.out.println("hasExpiringCert ERROR - This jar contains entries whose signer certificate will expire within six months. ");
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            System.out.println("hasExpiredCert ERROR - The signer certificate has expired. ");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            System.out.println("notYetValidCert ERROR - The signer certificate is not yet valid. ");
        }
        this.checkCertUsage(x509Certificate2, null);
        if (!x509Certificate2.equals(x509CertificateArray[0])) {
            object2 = new X509Certificate[x509CertificateArray.length];
            object2[0] = x509Certificate2;
            object = x509Certificate2.getIssuerDN();
            for (int i = 1; i < x509CertificateArray.length; ++i) {
                int n;
                for (n = 0; n < ((X509Certificate[])object2).length; ++n) {
                    Principal principal;
                    if (object2[n] == null || !object.equals(principal = object2[n].getSubjectDN())) continue;
                    x509CertificateArray[i] = object2[n];
                    object = object2[n].getIssuerDN();
                    object2[n] = null;
                    break;
                }
                if (n != ((X509Certificate[])object2).length) continue;
                throw new JarSignerException("incomplete certificate chain");
            }
            x509CertificateArray = object2;
        }
        object2 = null;
        object = null;
        object = jSParameters.getKeyStore().getKey(jSParameters.getAlias(), jSParameters.getKeyPass());
        if (!(object instanceof PrivateKey)) {
            MessageFormat messageFormat = new MessageFormat("key associated with alias not a private key");
            Object[] objectArray = new Object[]{jSParameters.getAlias()};
            throw new JarSignerException(messageFormat.format(objectArray));
        }
        object2 = (PrivateKey)object;
        return new Block(this, (PrivateKey)object2, string, x509CertificateArray, bl, string2, x509Certificate, timestampedSigner, jSParameters, zipFile);
    }

    public static class Block {
        private byte[] block;
        private String blockFileName;

        Block(SignatureFile signatureFile, PrivateKey privateKey, String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, TimestampedSigner timestampedSigner, JSParameters jSParameters, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException, JarSignerException {
            String string3;
            Object object;
            Principal principal = x509CertificateArray[0].getIssuerDN();
            if (!(principal instanceof X500Name)) {
                object = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
                principal = (Principal)object.get("issuer.dname");
            }
            String string4 = privateKey.getAlgorithm();
            if (string == null) {
                if (string4.equalsIgnoreCase("DSA")) {
                    object = "SHA1";
                } else if (string4.equalsIgnoreCase("RSA")) {
                    object = "SHA1";
                } else {
                    throw new JarSignerException("private key is not a DSA or RSA key");
                }
                string3 = (String)object + "with" + string4;
            } else {
                string3 = string;
            }
            String string5 = string3.toUpperCase();
            if (string5.endsWith("WITHRSA") && !string4.equalsIgnoreCase("RSA") || string5.endsWith("WITHDSA") && !string4.equalsIgnoreCase("DSA")) {
                throw new SignatureException("private key algorithm is not compatible with signature algorithm");
            }
            this.blockFileName = "META-INF/" + signatureFile.getBaseName() + "." + string4;
            Signature signature = Signature.getInstance(string3);
            signature.initSign(privateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            signatureFile.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            if (timestampedSigner == null) {
                timestampedSigner = new TimestampedSigner();
            }
            URI uRI = null;
            try {
                if (string2 != null) {
                    uRI = new URI(string2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
            JarSignerParameters jarSignerParameters = new JarSignerParameters(uRI, x509Certificate, byArray2, string3, x509CertificateArray, byArray, zipFile);
            this.block = timestampedSigner.generateSignedData(jarSignerParameters, bl, string2 != null || x509Certificate != null);
        }

        public String getMetaName() {
            return this.blockFileName;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.block);
        }
    }
}

