/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.security.jarsigner;

import es.eucm.eadventure.editor.control.security.jarsigner.JSParameters;
import es.eucm.eadventure.editor.control.security.jarsigner.JarBASE64Encoder;
import es.eucm.eadventure.editor.control.security.jarsigner.JarSignerException;
import es.eucm.eadventure.editor.control.security.jarsigner.SignatureFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Encoder;
import sun.security.util.ManifestDigester;
import sun.security.util.SignatureFileVerifier;

public class JSSigner {
    private static final String META_INF = "META-INF/";
    private static ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private static byte[] buffer = new byte[8192];
    private static final String SIG_PREFIX = "META-INF/SIG-";
    static String digestalg = "SHA1";
    static boolean signManifest = true;
    static X509Certificate[] certChain;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void signJar(JSParameters jSParameters) throws JarSignerException {
        Object[] objectArray;
        Cloneable cloneable;
        Object object;
        Object object2;
        boolean bl = false;
        X509Certificate x509Certificate = null;
        ZipFile zipFile = null;
        String string = null;
        if (string == null) {
            string = jSParameters.getAlias();
            bl = true;
        }
        string = string.length() > 8 ? string.substring(0, 8).toUpperCase() : string.toUpperCase();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (!(n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95)) {
                if (!bl) throw new JarSignerException("signature filename must consist of the following characters: A-Z, 0-9, _ or -");
                n = 95;
            }
            stringBuilder.append((char)n);
        }
        string = stringBuilder.toString();
        String string2 = jSParameters.getSignedJARName() == null ? jSParameters.getJarName() + ".sig" : jSParameters.getSignedJARName();
        File file = new File(jSParameters.getJarName());
        File file2 = new File(string2);
        try {
            object2 = jSParameters.getJarName();
            zipFile = new ZipFile((String)object2);
        }
        catch (IOException iOException) {
            throw new JarSignerException("unable to open jar file: " + jSParameters.getJarName());
        }
        object2 = null;
        try {
            object2 = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            throw new JarSignerException("unable to create: " + string2);
        }
        PrintStream printStream = new PrintStream((OutputStream)object2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(printStream);
        String string3 = (META_INF + string + ".SF").toUpperCase();
        String string4 = (META_INF + string + ".DSA").toUpperCase();
        Manifest manifest = new Manifest();
        Map<String, Attributes> map = manifest.getEntries();
        Attributes attributes = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Object var19_23 = null;
        try {
            ZipEntry zipEntry;
            void var19_29;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object = new MessageDigest[]{MessageDigest.getInstance(digestalg)};
            cloneable = JSSigner.getManifestFile(zipFile);
            if (cloneable != null) {
                byte[] byArray = JSSigner.getBytes(zipFile, (ZipEntry)cloneable);
                manifest.read(new ByteArrayInputStream(byArray));
                attributes = (Attributes)manifest.getMainAttributes().clone();
            } else {
                objectArray = manifest.getMainAttributes();
                objectArray.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                object6 = System.getProperty("java.vendor");
                object5 = System.getProperty("java.version");
                objectArray.putValue("Created by", (String)object5 + " (" + (String)object6 + ")");
                cloneable = new ZipEntry("META-INF/MANIFEST.MF");
                bl2 = true;
            }
            objectArray = new JarBASE64Encoder();
            object6 = new Vector();
            object5 = zipFile.entries();
            while (object5.hasMoreElements()) {
                object4 = (ZipEntry)object5.nextElement();
                if (((ZipEntry)object4).getName().startsWith(META_INF)) {
                    ((Vector)object6).addElement(object4);
                    if (JSSigner.signatureRelated(((ZipEntry)object4).getName())) continue;
                }
                if (manifest.getAttributes(((ZipEntry)object4).getName()) != null) {
                    if (!JSSigner.updateDigests((ZipEntry)object4, zipFile, (MessageDigest[])object, (BASE64Encoder)objectArray, manifest)) continue;
                    bl3 = true;
                    continue;
                }
                if (((ZipEntry)object4).isDirectory()) continue;
                Attributes attributes2 = JSSigner.getDigestAttributes((ZipEntry)object4, zipFile, (MessageDigest[])object, (BASE64Encoder)objectArray);
                map.put(((ZipEntry)object4).getName(), attributes2);
                bl3 = true;
            }
            if (bl3) {
                void var19_25;
                object5 = new ByteArrayOutputStream();
                manifest.write((OutputStream)object5);
                object4 = ((ByteArrayOutputStream)object5).toByteArray();
                if (var19_25 != null && attributes.equals(manifest.getMainAttributes())) {
                    int n;
                    Object object7 = object4;
                    int n2 = JSSigner.findHeaderEnd((byte[])object4);
                    if (n2 == (n = JSSigner.findHeaderEnd((byte[])object7))) {
                        System.arraycopy(object7, 0, object4, 0, n);
                    } else {
                        object3 = new byte[n + ((Object)object4).length - n2];
                        System.arraycopy(object7, 0, object3, 0, n);
                        System.arraycopy(object4, n2, object3, n, ((Object)object4).length - n2);
                        object4 = object3;
                    }
                }
                Object object8 = object4;
            }
            if (bl3) {
                cloneable = new ZipEntry("META-INF/MANIFEST.MF");
            }
            if (jSParameters.isVerbose()) {
                if (bl2) {
                    System.out.println(" adding: " + ((ZipEntry)cloneable).getName());
                } else if (bl3) {
                    System.out.println(" updating: " + ((ZipEntry)cloneable).getName());
                }
            }
            zipOutputStream.putNextEntry((ZipEntry)cloneable);
            zipOutputStream.write((byte[])var19_29);
            object5 = new ManifestDigester((byte[])var19_29);
            object4 = new SignatureFile((MessageDigest[])object, manifest, (ManifestDigester)object5, string, signManifest);
            SignatureFile.Block block = null;
            try {
                block = ((SignatureFile)object4).generateBlock(null, certChain, true, null, x509Certificate, null, jSParameters, zipFile);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new JarSignerException("unable to sign jar: no response from the Timestamping Authority. When connecting from behind a firewall then an HTTP proxy may need to be specified. Supply the following options to jarsigner: \n  -J-Dhttp.proxyHost=<hostname> \n  -J-Dhttp.proxyPort=<portnumber> ", socketTimeoutException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new JarSignerException("unable to sign jar: " + invalidKeyException.getMessage());
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new JarSignerException("unable to sign jar: " + unrecoverableKeyException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new JarSignerException("unable to sign jar: " + noSuchAlgorithmException.getMessage());
            }
            catch (SignatureException signatureException) {
                throw new JarSignerException("unable to sign jar: " + signatureException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new JarSignerException("unable to sign jar: " + certificateException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                throw new JarSignerException("unable to sign jar: " + keyStoreException.getMessage());
            }
            catch (JarSignerException jarSignerException) {
                throw new JarSignerException("unable to sign jar: " + jarSignerException.getMessage());
            }
            string3 = ((SignatureFile)object4).getMetaName();
            string4 = block.getMetaName();
            ZipEntry zipEntry2 = new ZipEntry(string3);
            object3 = new ZipEntry(string4);
            long l = System.currentTimeMillis();
            zipEntry2.setTime(l);
            ((ZipEntry)object3).setTime(l);
            zipOutputStream.putNextEntry(zipEntry2);
            ((SignatureFile)object4).write(zipOutputStream);
            zipOutputStream.putNextEntry((ZipEntry)object3);
            block.write(zipOutputStream);
            for (int i = 0; i < ((Vector)object6).size(); ++i) {
                zipEntry = (ZipEntry)((Vector)object6).elementAt(i);
                if (zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || zipEntry.getName().equalsIgnoreCase(string3) || zipEntry.getName().equalsIgnoreCase(string4)) continue;
                JSSigner.writeEntry(zipFile, zipOutputStream, zipEntry);
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.getName().startsWith(META_INF)) continue;
                JSSigner.writeEntry(zipFile, zipOutputStream, zipEntry);
            }
        }
        catch (IOException iOException) {
            throw new JarSignerException("unable to sign jar: " + iOException, iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JarSignerException("unable to sign jar: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    throw new JarSignerException("Exception with zipFile");
                }
                zipFile = null;
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new JarSignerException("Exception with zipFile");
                }
            }
        }
        if (jSParameters.getSignedJARName() != null) return;
        if (file2.renameTo(file)) return;
        object = new File(jSParameters.getJarName() + ".orig");
        if (!file.renameTo((File)object)) {
            cloneable = new MessageFormat("attempt to rename jarFile to origJar failed");
            objectArray = new Object[]{file, object};
            throw new JarSignerException(((Format)cloneable).format(objectArray));
        }
        if (file2.renameTo(file)) {
            ((File)object).delete();
            return;
        }
        cloneable = new MessageFormat("attempt to rename signedJarFile to jarFile failed");
        objectArray = new Object[]{file2, file};
        throw new JarSignerException(((Format)cloneable).format(objectArray));
    }

    private static ZipEntry getManifestFile(ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements() && zipEntry == null) {
                zipEntry = enumeration.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(zipEntry.getName())) continue;
                zipEntry = null;
            }
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized byte[] getBytes(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = zipFile.getInputStream(zipEntry);
            baos.reset();
            for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(buffer, 0, buffer.length)) != -1; i -= (long)n) {
                baos.write(buffer, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return baos.toByteArray();
    }

    private static boolean signatureRelated(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("META-INF/MANIFEST.MF") || string2.equals(META_INF) || string2.startsWith(SIG_PREFIX) && string2.indexOf("/") == string2.lastIndexOf("/")) {
            return true;
        }
        if (string2.startsWith(META_INF) && SignatureFileVerifier.isBlockOrSF(string2)) {
            return string2.indexOf("/") == string2.lastIndexOf("/");
        }
        return false;
    }

    private static boolean updateDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder, Manifest manifest) throws IOException {
        boolean bl = false;
        Attributes attributes = manifest.getAttributes(zipEntry.getName());
        String[] stringArray = JSSigner.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        for (int i = 0; i < messageDigestArray.length; ++i) {
            String string = messageDigestArray[i].getAlgorithm() + "-Digest";
            String string2 = attributes.getValue(string);
            if (string2 == null && messageDigestArray[i].getAlgorithm().equalsIgnoreCase("SHA")) {
                string2 = attributes.getValue("SHA-Digest");
            }
            if (string2 == null) {
                attributes.putValue(string, stringArray[i]);
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase(stringArray[i])) continue;
            attributes.putValue(string, stringArray[i]);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String[] getDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        int n;
        InputStream inputStream = null;
        try {
            int n2;
            inputStream = zipFile.getInputStream(zipEntry);
            for (long i = zipEntry.getSize(); i > 0L && (n2 = inputStream.read(buffer, 0, buffer.length)) != -1; i -= (long)n2) {
                for (n = 0; n < messageDigestArray.length; ++n) {
                    messageDigestArray[n].update(buffer, 0, n2);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        String[] stringArray = new String[messageDigestArray.length];
        for (n = 0; n < messageDigestArray.length; ++n) {
            stringArray[n] = bASE64Encoder.encode(messageDigestArray[n].digest());
        }
        return stringArray;
    }

    private static Attributes getDigestAttributes(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        String[] stringArray = JSSigner.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        Attributes attributes = new Attributes();
        for (int i = 0; i < messageDigestArray.length; ++i) {
            attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", stringArray[i]);
        }
        return attributes;
    }

    private static int findHeaderEnd(byte[] byArray) {
        if (byArray.length > 1 && byArray[0] == 13 && byArray[1] == 10) {
            return 0;
        }
        for (int i = 0; i < byArray.length - 3; ++i) {
            if (byArray[i] != 13 || byArray[i + 1] != 10 || byArray[i + 2] != 13 || byArray[i + 3] != 10) continue;
            return i;
        }
        return 0;
    }

    private static void writeEntry(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setMethod(zipEntry.getMethod());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setExtra(zipEntry.getExtra());
        if (zipEntry.getMethod() == 0) {
            zipEntry2.setSize(zipEntry.getSize());
            zipEntry2.setCrc(zipEntry.getCrc());
        }
        zipOutputStream.putNextEntry(zipEntry2);
        JSSigner.writeBytes(zipFile, zipEntry, zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeBytes(ZipFile zipFile, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = zipFile.getInputStream(zipEntry);
            for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(buffer, 0, buffer.length)) != -1; i -= (long)n) {
                zipOutputStream.write(buffer, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

