/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.security.jarsigner;

import es.eucm.eadventure.editor.control.security.jarsigner.FileNameGenerator;
import es.eucm.eadventure.editor.control.security.jarsigner.JarSignerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.util.jar.JarFile;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

class JSParameters {
    public static final String defaultKeystorePath = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String loggerName = "org.apache.harmony.tools.jarsigner.JarSignerLogger";
    private KeyStore keyStore;
    private JarFile jarFile;
    private String jarURIPath;
    private String jarName;
    private String alias;
    private boolean isVerify;
    private String storeURI;
    private String storeType = KeyStore.getDefaultType();
    private char[] storePass;
    private char[] keyPass;
    private String sigFileName;
    private String signedJARName;
    private boolean isCerts;
    private boolean isVerbose;
    private boolean isInternalSF;
    private boolean isSectionsOnly;
    private String provider;
    private String providerName;
    private String certProvider;
    private String certProviderName;
    private String sigProvider;
    private String sigProviderName;
    private String ksProvider;
    private String ksProviderName;
    private String mdProvider;
    private String mdProviderName;
    private URI tsaURI;
    private String tsaCertAlias;
    private String altSigner;
    private String altSignerPath;
    private String helpTopic;
    private boolean isSFNameProcessed;
    private String keyAlg;
    private String sigAlg;
    private boolean isSilent;
    private String proxy;
    private int proxyPort;
    private Proxy.Type proxyType;
    boolean nullStream = false;
    boolean token = false;

    JSParameters() {
    }

    void setDefault() {
        this.keyStore = null;
        this.jarFile = null;
        this.jarName = null;
        this.jarURIPath = null;
        this.alias = null;
        this.storeURI = null;
        this.storeType = KeyStore.getDefaultType();
        this.storePass = null;
        this.keyPass = null;
        this.sigFileName = null;
        this.signedJARName = null;
        this.isVerify = false;
        this.isCerts = false;
        this.isVerbose = false;
        this.isInternalSF = false;
        this.isSectionsOnly = false;
        this.provider = null;
        this.providerName = null;
        this.certProvider = null;
        this.certProviderName = null;
        this.sigProvider = null;
        this.sigProviderName = null;
        this.ksProvider = null;
        this.ksProviderName = null;
        this.mdProvider = null;
        this.mdProviderName = null;
        this.tsaURI = null;
        this.tsaCertAlias = null;
        this.altSigner = null;
        this.altSignerPath = null;
        this.helpTopic = null;
        this.isSFNameProcessed = false;
        this.keyAlg = null;
        this.sigAlg = null;
        this.isSilent = false;
        this.proxy = null;
        this.proxyPort = 8888;
        this.proxyType = Proxy.Type.HTTP;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setAltSigner(String string) {
        this.altSigner = string;
    }

    public void setAltSignerPath(String string) {
        this.altSignerPath = string;
    }

    public void setCertProvider(String string) {
        this.certProvider = string;
    }

    public void setCertProviderName(String string) {
        this.certProviderName = string;
    }

    public void setHelpTopic(String string) {
        this.helpTopic = string;
    }

    public void setCerts(boolean bl) {
        this.isCerts = bl;
    }

    public void setInternalSF(boolean bl) {
        this.isInternalSF = bl;
    }

    public void setSectionsOnly(boolean bl) {
        this.isSectionsOnly = bl;
    }

    public void setVerbose(boolean bl) {
        if (!this.isSilent) {
            Handler[] handlerArray;
            Logger logger = Logger.getLogger(loggerName);
            for (Handler handler : handlerArray = logger.getHandlers()) {
                if (bl) {
                    logger.setLevel(Level.FINE);
                    handler.setLevel(Level.FINE);
                    continue;
                }
                logger.setLevel(Level.INFO);
                handler.setLevel(Level.INFO);
            }
        }
        this.isVerbose = bl;
    }

    public void setVerify(boolean bl) {
        this.isVerify = bl;
    }

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public void setJarURIorPath(String string) {
        this.jarURIPath = string;
    }

    void setKeyAlg(String string) {
        this.keyAlg = string;
    }

    public void setKeyPass(char[] cArray) {
        this.keyPass = cArray;
    }

    void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKsProvider(String string) {
        this.ksProvider = string;
    }

    public void setKsProviderName(String string) {
        this.ksProviderName = string;
    }

    public void setMdProvider(String string) {
        this.mdProvider = string;
    }

    public void setMdProviderName(String string) {
        this.mdProviderName = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void setProviderName(String string) {
        this.providerName = string;
    }

    public void setProxy(String string) {
        this.proxy = string;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public void setProxyType(Proxy.Type type) {
        this.proxyType = type;
    }

    void setSigAlg(String string) {
        this.sigAlg = string;
    }

    public void setSigFileName(String string) {
        this.jarName = string;
        this.sigFileName = string;
        this.isSFNameProcessed = false;
    }

    public void setSignedJARName(String string) {
        this.signedJARName = string;
    }

    public void setSigProvider(String string) {
        this.sigProvider = string;
    }

    public void setSigProviderName(String string) {
        this.sigProviderName = string;
    }

    public void setSilent(boolean bl) {
        Handler[] handlerArray;
        Logger logger = Logger.getLogger(loggerName);
        for (Handler handler : handlerArray = logger.getHandlers()) {
            if (bl) {
                logger.setLevel(Level.OFF);
                continue;
            }
            if (this.isVerbose) {
                logger.setLevel(Level.FINE);
                handler.setLevel(Level.FINE);
                continue;
            }
            logger.setLevel(Level.INFO);
            handler.setLevel(Level.INFO);
        }
        this.isSilent = bl;
    }

    public void setStorePass(char[] cArray) {
        this.storePass = cArray;
    }

    public void setStoreType(String string) {
        this.storeType = string;
    }

    public void setStoreURI(String string) {
        this.storeURI = string;
    }

    public void setTsaCertAlias(String string) {
        this.tsaCertAlias = string;
    }

    public void setTsaURI(URI uRI) {
        this.tsaURI = uRI;
    }

    String getAlias() {
        return this.alias;
    }

    String getAltSigner() {
        return this.altSigner;
    }

    String getAltSignerPath() {
        return this.altSignerPath;
    }

    String getCertProvider() {
        return this.certProvider;
    }

    String getCertProviderName() {
        return this.certProviderName;
    }

    String getHelpTopic() {
        return this.helpTopic;
    }

    boolean isCerts() {
        return this.isCerts;
    }

    boolean isInternalSF() {
        return this.isInternalSF;
    }

    boolean isSectionsOnly() {
        return this.isSectionsOnly;
    }

    boolean isSilent() {
        return this.isSilent;
    }

    boolean isVerbose() {
        return this.isVerbose;
    }

    boolean isVerify() {
        return this.isVerify;
    }

    JarFile getJarFile() throws IOException {
        if (this.jarFile == null) {
            try {
                File file;
                try {
                    URI uRI = new URI(this.jarURIPath);
                    file = new File(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(this.jarURIPath);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    file = new File(this.jarURIPath);
                }
                this.jarFile = new JarFile(file, this.isVerify);
            }
            catch (IOException iOException) {
                throw (IOException)new IOException("Failed to load JAR file " + this.jarURIPath).initCause(iOException);
            }
        }
        return this.jarFile;
    }

    String getJarURIorPath() {
        return this.jarURIPath;
    }

    String getKeyAlg() {
        return this.keyAlg;
    }

    char[] getKeyPass() {
        return this.keyPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore getKeyStore() throws JarSignerException {
        if (this.keyStore == null) {
            KeyStore keyStore = null;
            if (this.providerName == null) {
                try {
                    keyStore = KeyStore.getInstance(this.storeType);
                }
                catch (KeyStoreException keyStoreException) {
                    keyStoreException.printStackTrace();
                }
            } else {
                try {
                    keyStore = KeyStore.getInstance(this.storeType, this.providerName);
                }
                catch (KeyStoreException keyStoreException) {
                    keyStoreException.printStackTrace();
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    noSuchProviderException.printStackTrace();
                }
            }
            if (this.storeURI == null) {
                throw new JarSignerException("Cannot load the keystore  error con el keystore");
            }
            try {
                this.storeURI = this.storeURI.replace(File.separatorChar, '/');
                URL uRL = null;
                try {
                    uRL = new URL(this.storeURI);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = new File(this.storeURI).toURI().toURL();
                }
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    keyStore.load(inputStream, this.storePass);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                throw new JarSignerException("Cannot load the keystore " + this.storeURI, exception);
            }
            this.keyStore = keyStore;
        }
        return this.keyStore;
    }

    String getKsProvider() {
        return this.ksProvider;
    }

    String getKsProviderName() {
        return this.ksProviderName;
    }

    String getMdProvider() {
        return this.mdProvider;
    }

    String getMdProviderName() {
        return this.mdProviderName;
    }

    String getProvider() {
        return this.provider;
    }

    String getProviderName() {
        return this.providerName;
    }

    String getProxy() {
        return this.proxy;
    }

    int getProxyPort() {
        return this.proxyPort;
    }

    Proxy.Type getProxyType() {
        return this.proxyType;
    }

    String getSigAlg() {
        return this.sigAlg;
    }

    String getSigFileName() {
        if (!this.isSFNameProcessed) {
            this.sigFileName = FileNameGenerator.generateFileName(this.sigFileName, this.alias);
            this.isSFNameProcessed = true;
        }
        return this.sigFileName;
    }

    String getSignedJARName() {
        return this.signedJARName;
    }

    String getSigProvider() {
        return this.sigProvider;
    }

    String getSigProviderName() {
        return this.sigProviderName;
    }

    char[] getStorePass() {
        return this.storePass;
    }

    String getStoreType() {
        if (this.storeType == null) {
            this.storeType = KeyStore.getDefaultType();
        }
        return this.storeType;
    }

    String getStoreURI() {
        return this.storeURI;
    }

    String getTsaCertAlias() {
        return this.tsaCertAlias;
    }

    URI getTsaURI() {
        return this.tsaURI;
    }
}

