/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.security.jarsigner;

import es.eucm.eadventure.editor.control.security.jarsigner.JSParameters;
import es.eucm.eadventure.editor.control.security.jarsigner.JarSignerException;
import es.eucm.eadventure.editor.control.security.jarsigner.UserInteractor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.logging.Logger;

class ArgParser {
    static final String sVerify = "-verify";
    static final String sKeyStore = "-keystore";
    static final String sStoreType = "-storetype";
    static final String sStorePass = "-storepass";
    static final String sKeyPass = "-keypass";
    static final String sSigFile = "-sigfile";
    static final String sSignedJAR = "-signedjar";
    static final String sCerts = "-certs";
    static final String sVerbose = "-verbose";
    static final String sInternalSF = "-internalsf";
    static final String sSectionsOnly = "-sectionsonly";
    static final String sProvider = "-providerclass";
    static final String sProviderName = "-providername";
    static final String sCertProvider = "-certproviderclass";
    static final String sCertProviderName = "-certprovidername";
    static final String sSigProvider = "-sigproviderclass";
    static final String sSigProviderName = "-sigprovidername";
    static final String sKSProvider = "-ksproviderclass";
    static final String sKSProviderName = "-ksprovidername";
    static final String sMDProvider = "-mdproviderclass";
    static final String sMDProviderName = "-mdprovidername";
    static final String sTSA = "-tsa";
    static final String sTSAcert = "-tsacert";
    static final String sProxy = "-proxy";
    static final String sProxyType = "-proxytype";
    static final String sSilent = "-silent";
    static final String sAltSigner = "-altsigner";
    static final String sAltSignerPath = "-altsignerpath";

    ArgParser() {
    }

    static JSParameters parseArgs(String[] stringArray, JSParameters jSParameters) throws JarSignerException, IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        String string;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        if (jSParameters == null) {
            jSParameters = new JSParameters();
        } else {
            jSParameters.setDefault();
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(sVerify)) {
                    jSParameters.setVerify(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sKeyStore)) {
                    jSParameters.setStoreURI(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sStoreType)) {
                    jSParameters.setStoreType(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sStorePass)) {
                    jSParameters.setStorePass(stringArray[++i].toCharArray());
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sKeyPass)) {
                    jSParameters.setKeyPass(stringArray[++i].toCharArray());
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSigFile)) {
                    jSParameters.setSigFileName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSignedJAR)) {
                    jSParameters.setSignedJARName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sCerts)) {
                    jSParameters.setCerts(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sVerbose)) {
                    jSParameters.setVerbose(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSilent)) {
                    jSParameters.setSilent(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sInternalSF)) {
                    jSParameters.setInternalSF(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSectionsOnly)) {
                    jSParameters.setSectionsOnly(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sProvider)) {
                    jSParameters.setProvider(stringArray[++i]);
                    ArgParser.addProvider(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sProviderName)) {
                    jSParameters.setProviderName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sCertProvider)) {
                    jSParameters.setCertProvider(stringArray[++i]);
                    ArgParser.addProvider(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sCertProviderName)) {
                    jSParameters.setCertProviderName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSigProvider)) {
                    jSParameters.setSigProvider(stringArray[++i]);
                    ArgParser.addProvider(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sSigProviderName)) {
                    jSParameters.setSigProviderName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sKSProvider)) {
                    jSParameters.setKsProvider(stringArray[++i]);
                    ArgParser.addProvider(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sKSProviderName)) {
                    jSParameters.setKsProviderName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sMDProvider)) {
                    jSParameters.setMdProvider(stringArray[++i]);
                    ArgParser.addProvider(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sMDProviderName)) {
                    jSParameters.setMdProviderName(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sTSA)) {
                    try {
                        jSParameters.setTsaURI(new URI(stringArray[++i]));
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new JarSignerException("Argument " + stringArray[i] + " is not an URI");
                    }
                }
                if (stringArray[i].equalsIgnoreCase(sTSAcert)) {
                    jSParameters.setTsaCertAlias(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sProxy)) {
                    int n;
                    int n2;
                    if ((n2 = stringArray[++i].lastIndexOf(58)) == -1) {
                        jSParameters.setProxy(stringArray[i]);
                        continue;
                    }
                    String string2 = stringArray[i].substring(0, n2);
                    try {
                        n = Integer.parseInt(stringArray[i].substring(n2 + 1, stringArray[i].length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JarSignerException("Proxy port must be an integer value.");
                    }
                    jSParameters.setProxy(string2);
                    jSParameters.setProxyPort(n);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sAltSigner)) {
                    jSParameters.setAltSigner(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(sAltSignerPath)) {
                    jSParameters.setAltSignerPath(stringArray[++i]);
                    continue;
                }
                if (jSParameters.isVerify() && i == stringArray.length - 1 || !jSParameters.isVerify() && i == stringArray.length - 2) {
                    jSParameters.setJarURIorPath(stringArray[i]);
                    continue;
                }
                if (!jSParameters.isVerify() && i == stringArray.length - 1) {
                    jSParameters.setAlias(stringArray[i]);
                    continue;
                }
                System.out.println("Illegal option: " + stringArray[i]);
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if ((string = jSParameters.getProviderName()) != null) {
            if (jSParameters.getCertProviderName() == null) {
                jSParameters.setCertProviderName(string);
            }
            if (jSParameters.getSigProviderName() == null) {
                jSParameters.setSigProviderName(string);
            }
            if (jSParameters.getKsProviderName() == null) {
                jSParameters.setKsProviderName(string);
            }
            if (jSParameters.getMdProviderName() == null) {
                jSParameters.setMdProviderName(string);
            }
        }
        if (jSParameters.getStorePass() == null) {
            jSParameters.setStorePass(UserInteractor.getDataFromUser("Enter keystore password:  "));
            jSParameters.getKeyStore();
        }
        if (jSParameters.getAlias() == null && !jSParameters.isVerify()) {
            jSParameters.setAlias(new String(UserInteractor.getDataFromUser("Enter alias name:  ")));
        }
        if (!jSParameters.getKeyStore().containsAlias(jSParameters.getAlias())) {
            throw new JarSignerException("The alias " + jSParameters.getAlias() + " does not exist in keystore");
        }
        if (jSParameters.getKeyPass() == null) {
            jSParameters.setKeyPass(ArgParser.tryStorePassAsKeyPass(jSParameters.getKeyStore(), jSParameters.getAlias(), jSParameters.getStorePass()));
        }
        if (jSParameters.isInternalSF() || jSParameters.isSectionsOnly() || jSParameters.getAltSigner() != null || jSParameters.getAltSignerPath() != null) {
            Logger.getLogger("org.apache.harmony.tools.jarsigner.JarSignerLogger").warning("Options -altsigner, -altsignerpath, -internalsf, -sectionsonly are currently ignored since they eliminate useful optimizations. ");
        }
        return jSParameters;
    }

    private static char[] tryStorePassAsKeyPass(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, IOException, UnrecoverableKeyException, NoSuchAlgorithmException {
        try {
            keyStore.getKey(string, cArray);
            return cArray;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            char[] cArray2 = UserInteractor.getDataFromUser("Enter key password for <" + string + ">: ");
            try {
                keyStore.getKey(string, cArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmException("Cannot find the algorithm to recover the key. ", unrecoverableKeyException);
            }
            return cArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Cannot find the algorithm to recover the key. ", noSuchAlgorithmException);
        }
    }

    static int addProvider(String string) throws JarSignerException {
        try {
            return Security.addProvider(Class.forName(string).asSubclass(Provider.class).newInstance());
        }
        catch (Exception exception) {
            throw new JarSignerException("Failed to load the provider " + string, exception);
        }
    }
}

