/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.security;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.editor.control.security.jarsigner.Main;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.security.tools.KeyTool;

public class JARSigner {
    private static final String KEY_STORE_NAME = "eAdventure.keystore";
    private static final String KEY_STORE_PASSWORD = "3Adv3ntur3_K3YSTOR3";
    private static KeyStore keyStore;
    private static SecureRandom pwdGenerator;

    private static void initRandom() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = secureRandom.generateSeed(12);
        pwdGenerator = new SecureRandom();
        pwdGenerator.setSeed(byArray);
    }

    private static boolean init() {
        boolean bl = false;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(new FileInputStream(KEY_STORE_NAME), KEY_STORE_PASSWORD.toCharArray());
            bl = true;
            JARSigner.initRandom();
        }
        catch (Exception exception) {
            try {
                keyStore.load(null, KEY_STORE_PASSWORD.toCharArray());
                keyStore.store(new FileOutputStream(KEY_STORE_NAME), KEY_STORE_PASSWORD.toCharArray());
                bl = true;
                JARSigner.initRandom();
            }
            catch (Exception exception2) {
                ReportDialog.GenerateErrorReport((Exception)exception2, (boolean)true, (String)"UNKNOWERROR");
            }
        }
        return bl;
    }

    private static String validateDistinguisedNameEntry(String string) {
        return string.replace(",", "\\,");
    }

    private static String generatePassword() {
        String string = "";
        block10: for (int i = 0; i < 8; ++i) {
            block0 : switch (pwdGenerator.nextInt(4)) {
                case 0: {
                    string = string + Integer.toString(pwdGenerator.nextInt(10));
                    continue block10;
                }
                case 1: {
                    string = string + (char)(pwdGenerator.nextInt(26) + 97);
                    continue block10;
                }
                case 2: {
                    string = string + (char)(pwdGenerator.nextInt(26) + 65);
                    continue block10;
                }
                case 3: {
                    switch (pwdGenerator.nextInt(2)) {
                        case 0: {
                            string = string + "_";
                            break block0;
                        }
                        case 1: {
                            string = string + "&";
                        }
                    }
                }
            }
        }
        return string;
    }

    public static String generateAlias(String string) {
        String string2 = "";
        int n = 0;
        try {
            do {
                string2 = "";
                for (char c : string.toCharArray()) {
                    string2 = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' ? string2 + c : string2 + "_";
                }
                string2 = string2 + "_" + n;
                ++n;
            } while (keyStore.containsAlias(string2));
        }
        catch (Exception exception) {
            string2 = KEY_STORE_PASSWORD;
        }
        return string2;
    }

    public static boolean signJar(String string, String string2, String string3, String string4) {
        boolean bl = false;
        boolean bl2 = JARSigner.init();
        String string5 = null;
        if (bl2 && string.length() >= 6) {
            try {
                String string6 = "CN=" + JARSigner.validateDistinguisedNameEntry(string) + ", OU=" + JARSigner.validateDistinguisedNameEntry(string2) + ", O=" + JARSigner.validateDistinguisedNameEntry(string2);
                String string7 = JARSigner.generatePassword();
                string5 = JARSigner.generateAlias(string);
                KeyTool.main((String[])new String[]{"-genkeypair", "-alias", string5, "-dname", string6, "-keypass", string7, "-validity", "1000", "-keystore", KEY_STORE_NAME, "-storepass", KEY_STORE_PASSWORD});
                Main.main(new String[]{"-keystore", KEY_STORE_NAME, "-storepass", KEY_STORE_PASSWORD, "-keypass", string7, "-signedjar", new File(string4).getAbsolutePath(), "-sigfile", new File(string3).getAbsolutePath(), string5});
                JarFile jarFile = new JarFile(string4, true);
                Manifest manifest = jarFile.getManifest();
                Set<String> set = manifest.getEntries().keySet();
                for (String string8 : set) {
                    jarFile.getJarEntry(string8).getAttributes();
                }
                bl = true;
                System.out.println("Successfully signed Jar");
            }
            catch (Exception exception) {
                ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"UNKNOWERROR");
                bl = false;
            }
        }
        return bl;
    }
}

