/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.timer;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class TimersListDataControl
extends DataControl {
    private List<Timer> timersList;
    private List<TimerDataControl> timersDataControlList;

    public TimersListDataControl(List<Timer> list) {
        this.timersList = list;
        this.timersDataControlList = new ArrayList<TimerDataControl>();
        for (Timer timer : list) {
            this.timersDataControlList.add(new TimerDataControl(timer));
        }
    }

    public List<TimerDataControl> getTimers() {
        return this.timersDataControlList;
    }

    public TimerDataControl getLastTimer() {
        return this.timersDataControlList.get(this.timersDataControlList.size() - 1);
    }

    public String[][] getTimersInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.timersList.size()][6];
        for (int i = 0; i < this.timersList.size(); ++i) {
            Timer timer = this.timersList.get(i);
            stringArray[i][0] = Integer.toString(i);
            stringArray[i][1] = this.timersDataControlList.get(i).getTimeHhMmSs();
            stringArray[i][2] = !timer.getInitCond().isEmpty() ? TC.get((String)"GeneralText.Yes") : TC.get((String)"GeneralText.No");
            stringArray[i][3] = !timer.getEndCond().isEmpty() ? TC.get((String)"GeneralText.Yes") : TC.get((String)"GeneralText.No");
            stringArray[i][4] = !timer.getEffects().isEmpty() ? TC.get((String)"GeneralText.Yes") : TC.get((String)"GeneralText.No");
            stringArray[i][5] = !timer.getPostEffects().isEmpty() ? TC.get((String)"GeneralText.Yes") : TC.get((String)"GeneralText.No");
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.timersList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{44};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 44;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 44) {
            Timer timer = new Timer();
            timer.setRunsInLoop(Boolean.valueOf(false));
            timer.setMultipleStarts(Boolean.valueOf(false));
            timer.setUsesEndCondition(Boolean.valueOf(false));
            this.timersList.add(timer);
            this.timersDataControlList.add(new TimerDataControl(timer));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof TimerDataControl)) {
            return false;
        }
        try {
            Timer timer = (Timer)((Timer)dataControl.getContent()).clone();
            this.timersList.add(timer);
            this.timersDataControlList.add(new TimerDataControl(timer));
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone timer");
            return false;
        }
    }

    private int findDataControlIndex(DataControl dataControl) {
        int n = -1;
        for (int i = 0; i < this.timersDataControlList.size(); ++i) {
            if (this.timersDataControlList.get(i) != dataControl) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        int n = this.findDataControlIndex(dataControl);
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{TC.getElement((int)44) + " #" + Integer.toString(n), "0"}))) && this.timersList.remove(dataControl.getContent())) {
            this.timersDataControlList.remove(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.timersList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.timersList.add(n - 1, this.timersList.remove(n));
            this.timersDataControlList.add(n - 1, this.timersDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.timersList.indexOf(dataControl.getContent());
        if (n < this.timersList.size() - 1) {
            this.timersList.add(n + 1, this.timersList.remove(n));
            this.timersDataControlList.add(n + 1, this.timersDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            timerDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)45);
        for (int i = 0; i < this.timersDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)44) + " #" + i;
            bl &= this.timersDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            n += timerDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            timerDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            timerDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            n += timerDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            timerDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            timerDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (TimerDataControl timerDataControl : this.timersDataControlList) {
            ((Searchable)timerDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.timersDataControlList);
    }

    public List<Timer> getTimersList() {
        return this.timersList;
    }
}

