/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.timer;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeLongValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.HashMap;
import java.util.List;

public class TimerDataControl
extends DataControl {
    private Timer timer;
    private ConditionsController initConditionsController;
    private ConditionsController endConditionsController;
    private EffectsController effectsController;
    private EffectsController postEffectsController;

    public TimerDataControl(Timer timer) {
        this.timer = timer;
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
        ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(44, timer.getDisplayName());
        hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner);
        ConditionsController.ConditionCustomMessage conditionCustomMessage = new ConditionsController.ConditionCustomMessage(TC.get((String)"Conditions.Context.1A.44"), TC.get((String)"Conditions.Context.2A.44"));
        hashMap.put(ConditionsController.CONDITION_CUSTOM_MESSAGE, conditionCustomMessage);
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap2 = new HashMap<String, ConditionsController.ConditionContextProperty>();
        hashMap2.put(ConditionsController.CONDITION_OWNER, conditionOwner);
        ConditionsController.ConditionCustomMessage conditionCustomMessage2 = new ConditionsController.ConditionCustomMessage(TC.get((String)"Conditions.Context.1B.44"), TC.get((String)"Conditions.Context.2B.44"));
        hashMap2.put(ConditionsController.CONDITION_CUSTOM_MESSAGE, conditionCustomMessage2);
        this.initConditionsController = new ConditionsController(timer.getInitCond(), hashMap);
        this.endConditionsController = new ConditionsController(timer.getEndCond(), hashMap2);
        this.effectsController = new EffectsController(timer.getEffects());
        this.postEffectsController = new EffectsController(timer.getPostEffects());
    }

    public ConditionsController getInitConditions() {
        return this.initConditionsController;
    }

    public ConditionsController getEndConditions() {
        return this.endConditionsController;
    }

    public EffectsController getEffects() {
        return this.effectsController;
    }

    public EffectsController getPostEffects() {
        return this.postEffectsController;
    }

    @Override
    public Object getContent() {
        return this.timer;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.timer.getInitCond());
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.timer.getEndCond());
        EffectsController.updateVarFlagSummary(varFlagSummary, this.timer.getEffects());
        EffectsController.updateVarFlagSummary(varFlagSummary, this.timer.getPostEffects());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.Effects"), list, this.timer.getEffects());
        return bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.PostEffects"), list, this.timer.getPostEffects());
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        n += EffectsController.countAssetReferences(string, this.timer.getEffects());
        return n += EffectsController.countAssetReferences(string, this.timer.getPostEffects());
    }

    @Override
    public void deleteAssetReferences(String string) {
        EffectsController.deleteAssetReferences(string, this.timer.getEffects());
        EffectsController.deleteAssetReferences(string, this.timer.getPostEffects());
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        n += EffectsController.countIdentifierReferences(string, this.timer.getEffects());
        n += EffectsController.countIdentifierReferences(string, this.timer.getPostEffects());
        n += this.initConditionsController.countIdentifierReferences(string);
        return n += this.endConditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        EffectsController.replaceIdentifierReferences(string, string2, this.timer.getEffects());
        EffectsController.replaceIdentifierReferences(string, string2, this.timer.getPostEffects());
        this.initConditionsController.replaceIdentifierReferences(string, string2);
        this.endConditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        EffectsController.deleteIdentifierReferences(string, this.timer.getEffects());
        EffectsController.deleteIdentifierReferences(string, this.timer.getPostEffects());
        this.initConditionsController.deleteIdentifierReferences(string);
        this.endConditionsController.deleteIdentifierReferences(string);
    }

    public String getTimeHhMmSs() {
        String string = "";
        long l = this.timer.getTime();
        if (l < 60L && l >= 0L) {
            string = Long.toString(l) + "s";
        } else if (l < 3600L && l >= 60L) {
            long l2 = l / 60L;
            long l3 = l % 60L;
            string = Long.toString(l2) + "m:" + Long.toString(l3) + "s";
        } else if (l >= 3600L) {
            long l4 = l / 3600L;
            long l5 = l % 3600L / 60L;
            long l6 = l % 3600L % 60L;
            string = Long.toString(l4) + "h:" + Long.toString(l5) + "m:" + Long.toString(l6) + "s";
        }
        return string;
    }

    public long getTime() {
        return this.timer.getTime();
    }

    public String getDocumentation() {
        return this.timer.getDocumentation();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.timer, string));
    }

    public void setTime(long l) {
        this.controller.addTool(new ChangeLongValueTool(this.timer, l, "getTime", "setTime"));
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        EffectsController.getAssetReferences(list, list2, this.timer.getEffects());
        EffectsController.getAssetReferences(list, list2, this.timer.getPostEffects());
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        int n;
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getEndConditions(), TC.get((String)"Search.EndConditions"));
        this.check(this.getInitConditions(), TC.get((String)"Search.InitConditions"));
        for (n = 0; n < this.getEffects().getEffectCount(); ++n) {
            this.check(this.getEffects().getEffectInfo(n), TC.get((String)"Search.Effect"));
        }
        for (n = 0; n < this.getPostEffects().getEffectCount(); ++n) {
            this.check(this.getPostEffects().getEffectInfo(n), TC.get((String)"Search.PostEffect"));
        }
    }

    public boolean isUsesEndCondition() {
        return this.timer.isUsesEndCondition();
    }

    public void setUsesEndCondition(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isUsesEndCondition", "setUsesEndCondition"));
    }

    public boolean isMultipleStarts() {
        return this.timer.isMultipleStarts();
    }

    public void setMultipleStarts(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isMultipleStarts", "setMultipleStarts"));
    }

    public boolean isRunsInLoop() {
        return this.timer.isRunsInLoop();
    }

    public void setRunsInLoop(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isRunsInLoop", "setRunsInLoop"));
    }

    public boolean isShowTime() {
        return this.timer.isShowTime();
    }

    public void setShowTime(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isShowTime", "setShowTime"));
    }

    public boolean isCountDown() {
        return this.timer.isCountDown();
    }

    public void setCountDown(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isCountDown", "setCountDown"));
    }

    public boolean isShowWhenStopped() {
        return this.timer.isShowWhenStopped();
    }

    public void setShowWhenStopped(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.timer, bl, "isShowWhenStopped", "setShowWhenStopped"));
    }

    public String getDisplayName() {
        return this.timer.getDisplayName();
    }

    public void setDisplayName(String string) {
        this.controller.addTool(new ChangeStringValueTool(this.timer, string, "getDisplayName", "setDisplayName"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

