/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SideDataControl;
import es.eucm.eadventure.editor.control.tools.scene.AddTrajectoryNodeTool;
import es.eucm.eadventure.editor.control.tools.scene.AddTrajectorySideTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteTrajectoryNodeTool;
import es.eucm.eadventure.editor.control.tools.scene.DeleteTrajectorySideTool;
import es.eucm.eadventure.editor.control.tools.scene.SetTrajectoryInitialNodeTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class TrajectoryDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private Trajectory trajectory;
    private List<NodeDataControl> nodeDataControlList;
    private List<SideDataControl> sideDataControlList;
    public NodeDataControl initialNode;

    public TrajectoryDataControl(SceneDataControl sceneDataControl, Trajectory trajectory) {
        this.sceneDataControl = sceneDataControl;
        this.trajectory = trajectory;
        this.sideDataControlList = new ArrayList<SideDataControl>();
        this.nodeDataControlList = new ArrayList<NodeDataControl>();
        if (trajectory != null) {
            for (Trajectory.Node node : trajectory.getNodes()) {
                this.nodeDataControlList.add(new NodeDataControl(sceneDataControl, node, trajectory));
                if (node != trajectory.getInitial()) continue;
                this.initialNode = this.nodeDataControlList.get(this.nodeDataControlList.size() - 1);
                this.initialNode.setInitial(true);
            }
            for (Trajectory.Node node : trajectory.getSides()) {
                this.sideDataControlList.add(new SideDataControl(sceneDataControl, this, (Trajectory.Side)node));
            }
        }
    }

    public List<NodeDataControl> getNodes() {
        return this.nodeDataControlList;
    }

    public List<SideDataControl> getSides() {
        return this.sideDataControlList;
    }

    public NodeDataControl getLastNode() {
        return this.nodeDataControlList.get(this.nodeDataControlList.size() - 1);
    }

    public SideDataControl getLastSide() {
        return this.sideDataControlList.get(this.sideDataControlList.size() - 1);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    @Override
    public Object getContent() {
        return this.trajectory;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    public boolean addNode(int n, int n2) {
        if (this.trajectory == null) {
            return false;
        }
        Controller.getInstance().addTool(new AddTrajectoryNodeTool(this.trajectory, this, n, n2, this.sceneDataControl));
        return true;
    }

    public boolean addSide(NodeDataControl nodeDataControl, NodeDataControl nodeDataControl2) {
        if (nodeDataControl == nodeDataControl2) {
            return false;
        }
        Controller.getInstance().addTool(new AddTrajectorySideTool(nodeDataControl, nodeDataControl2, this.trajectory, this, this.sceneDataControl));
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        if (this.nodeDataControlList.contains(dataControl)) {
            if (this.nodeDataControlList.size() > 1) {
                Controller.getInstance().addTool(new DeleteTrajectoryNodeTool(dataControl, this.trajectory, this));
                return true;
            }
            return false;
        }
        if (this.sideDataControlList.contains(dataControl)) {
            Controller.getInstance().addTool(new DeleteTrajectorySideTool((SideDataControl)dataControl, this.trajectory, this));
            this.trajectory.getSides().remove(dataControl.getContent());
            this.sideDataControlList.remove(dataControl);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            dataControl.updateVarFlagSummary(varFlagSummary);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            sideDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        String string2;
        int n;
        boolean bl = true;
        for (n = 0; n < this.nodeDataControlList.size(); ++n) {
            string2 = string + " >> " + TC.getElement((int)62) + " #" + (n + 1);
            bl &= this.nodeDataControlList.get(n).isValid(string2, list);
        }
        for (n = 0; n < this.sideDataControlList.size(); ++n) {
            string2 = string + " >> " + TC.getElement((int)63) + " #" + (n + 1);
            bl &= this.sideDataControlList.get(n).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            n += dataControl.countAssetReferences(string);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            n += sideDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            dataControl.getAssetReferences(list, list2);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            sideDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            dataControl.deleteAssetReferences(string);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            sideDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            n += dataControl.countIdentifierReferences(string);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            n += sideDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            dataControl.replaceIdentifierReferences(string, string2);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            sideDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (NodeDataControl dataControl : this.nodeDataControlList) {
            dataControl.deleteIdentifierReferences(string);
        }
        for (SideDataControl sideDataControl : this.sideDataControlList) {
            sideDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public boolean hasTrajectory() {
        return this.trajectory != null;
    }

    public void setInitialNode(NodeDataControl nodeDataControl) {
        Controller.getInstance().addTool(new SetTrajectoryInitialNodeTool(this.trajectory, this, nodeDataControl));
    }

    public NodeDataControl getInitialNode() {
        return this.initialNode;
    }

    @Override
    public void recursiveSearch() {
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.nodeDataControlList);
        if (list != null) {
            return list;
        }
        return this.getPathFromChild(searchable, this.sideDataControlList);
    }
}

