/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ScenesListDataControl
extends DataControl {
    private List<Scene> scenesList;
    private List<SceneDataControl> scenesDataControlList;

    public ScenesListDataControl(List<Scene> list, String string) {
        this.scenesList = list;
        this.scenesDataControlList = new ArrayList<SceneDataControl>();
        for (Scene scene : list) {
            this.scenesDataControlList.add(new SceneDataControl(scene, string));
        }
    }

    public List<SceneDataControl> getScenes() {
        return this.scenesDataControlList;
    }

    public SceneDataControl getLastScene() {
        return this.scenesDataControlList.get(this.scenesDataControlList.size() - 1);
    }

    public String[][] getScenesInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.scenesList.size()][4];
        for (int i = 0; i < this.scenesList.size(); ++i) {
            Scene scene = this.scenesList.get(i);
            stringArray[i][0] = scene.getId();
            stringArray[i][1] = TC.get((String)"ScenesList.ExitsNumber", (String)String.valueOf(scene.getExits().size()));
            stringArray[i][2] = TC.get((String)"ScenesList.ItemsNumber", (String)String.valueOf(scene.getItemReferences().size()));
            stringArray[i][3] = TC.get((String)"ScenesList.NPCsNumber", (String)String.valueOf(scene.getCharacterReferences().size()));
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.scenesList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{2};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 2;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 2) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddSceneTitle"), TC.get((String)"Operation.AddSceneMessage"), TC.get((String)"Operation.AddSceneDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Scene scene = new Scene(string);
                this.scenesList.add(scene);
                this.scenesDataControlList.add(new SceneDataControl(scene, this.controller.getPlayerImagePath()));
                this.controller.getIdentifierSummary().addSceneId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof SceneDataControl)) {
            return false;
        }
        try {
            Scene scene = (Scene)((Scene)dataControl.getContent()).clone();
            String string = scene.getId();
            int n = 1;
            do {
                string = scene.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            scene.setId(string);
            this.scenesList.add(scene);
            this.scenesDataControlList.add(new SceneDataControl(scene, this.controller.getPlayerImagePath()));
            this.controller.getIdentifierSummary().addSceneId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone scene");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddSceneDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        int n = this.controller.getIdentifierSummary().getGeneralSceneIds().length;
        if (n > 1) {
            String string = ((SceneDataControl)dataControl).getId();
            String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
            if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.scenesDataControlList.remove(dataControl)) {
                this.scenesList.remove(dataControl.getContent());
                this.controller.deleteIdentifierReferences(string);
                this.controller.getIdentifierSummary().deleteSceneId(string);
                bl2 = true;
            }
        } else {
            this.controller.showErrorDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.ErrorLastScene"));
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.scenesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.scenesList.add(n - 1, this.scenesList.remove(n));
            this.scenesDataControlList.add(n - 1, this.scenesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.scenesList.indexOf(dataControl.getContent());
        if (n < this.scenesList.size() - 1) {
            this.scenesList.add(n + 1, this.scenesList.remove(n));
            this.scenesDataControlList.add(n + 1, this.scenesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)1);
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            String string2 = string + " >> " + sceneDataControl.getId();
            bl &= sceneDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            n += sceneDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            n += sceneDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public void addPlayerToAllScenes() {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.addPlayerInReferenceList();
        }
    }

    public void deletePlayerToAllScenes() {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            sceneDataControl.deletePlayerInReferenceList();
        }
    }

    @Override
    public void recursiveSearch() {
        for (SceneDataControl sceneDataControl : this.scenesDataControlList) {
            ((Searchable)sceneDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.scenesDataControlList);
    }
}

