/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarriersListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeAllowPlayerInSceneTool;
import es.eucm.eadventure.editor.control.tools.general.ChangeNSDestinyPositionTool;
import es.eucm.eadventure.editor.control.tools.general.ChangePositionTool;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.control.tools.scene.ChangePlayerScaleTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import java.util.ArrayList;
import java.util.List;

public class SceneDataControl
extends DataControlWithResources {
    private Scene scene;
    private ExitsListDataControl exitsListDataControl;
    private ReferencesListDataControl referencesListDataControl;
    private ActiveAreasListDataControl activeAreasListDataControl;
    private BarriersListDataControl barriersListDataControl;
    private TrajectoryDataControl trajectoryDataControl;

    public SceneDataControl(Scene scene, String string) {
        this.scene = scene;
        this.resourcesList = scene.getResources();
        this.selectedResources = 0;
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 2));
        }
        this.exitsListDataControl = new ExitsListDataControl(this, scene.getExits());
        this.referencesListDataControl = new ReferencesListDataControl(string, this, scene.getItemReferences(), scene.getAtrezzoReferences(), scene.getCharacterReferences());
        this.activeAreasListDataControl = new ActiveAreasListDataControl(this, scene.getActiveAreas());
        this.barriersListDataControl = new BarriersListDataControl(this, scene.getBarriers());
        this.trajectoryDataControl = new TrajectoryDataControl(this, scene.getTrajectory());
    }

    public ExitsListDataControl getExitsList() {
        return this.exitsListDataControl;
    }

    public ActiveAreasListDataControl getActiveAreasList() {
        return this.activeAreasListDataControl;
    }

    public BarriersListDataControl getBarriersList() {
        return this.barriersListDataControl;
    }

    public ReferencesListDataControl getReferencesList() {
        return this.referencesListDataControl;
    }

    public String getPreviewBackground() {
        return ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath("background");
    }

    public String getId() {
        return this.scene.getId();
    }

    public String getDocumentation() {
        return this.scene.getDocumentation();
    }

    public String getName() {
        return this.scene.getName();
    }

    public boolean hasDefaultInitialPosition() {
        return this.scene.hasDefaultPosition();
    }

    public int getDefaultInitialPositionX() {
        return this.scene.getPositionX();
    }

    public int getDefaultInitialPositionY() {
        return this.scene.getPositionY();
    }

    public void setName(String string) {
        ChangeNameTool changeNameTool = new ChangeNameTool((Named)this.scene, string);
        this.controller.addTool(changeNameTool);
    }

    public void imageChangeNotify(String string) {
        this.referencesListDataControl.changeImagePlayerPath(string);
    }

    public void setDocumentation(String string) {
        ChangeDocumentationTool changeDocumentationTool = new ChangeDocumentationTool((Documented)this.scene, string);
        this.controller.addTool(changeDocumentationTool);
    }

    public void toggleDefaultInitialPosition() {
        if (this.scene.hasDefaultPosition()) {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.scene, Integer.MIN_VALUE, Integer.MIN_VALUE));
        } else {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.scene, 400, 300));
        }
    }

    public void setDefaultInitialPosition(int n, int n2) {
        this.controller.addTool(new ChangePositionTool((Positioned)this.scene, n, n2));
    }

    @Override
    public Object getContent() {
        return this.scene;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, 2, this));
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.resourcesList.add(n - 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n - 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n < this.resourcesList.size() - 1) {
            this.resourcesList.add(n + 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n + 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.scene.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameSceneTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameSceneTitle"), TC.get((String)"Operation.RenameSceneMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.scene.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteSceneId(string2);
                this.controller.getIdentifierSummary().addSceneId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        this.exitsListDataControl.updateVarFlagSummary(varFlagSummary);
        this.referencesListDataControl.updateVarFlagSummary(varFlagSummary);
        this.activeAreasListDataControl.updateVarFlagSummary(varFlagSummary);
        this.barriersListDataControl.updateVarFlagSummary(varFlagSummary);
        this.trajectoryDataControl.updateVarFlagSummary(varFlagSummary);
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
            bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
        }
        bl &= this.exitsListDataControl.isValid(string, list);
        return bl &= this.trajectoryDataControl.isValid(string, list);
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        n += this.exitsListDataControl.countAssetReferences(string);
        return n += this.activeAreasListDataControl.countAssetReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.exitsListDataControl.getAssetReferences(list, list2);
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteAssetReferences(string);
        }
        this.exitsListDataControl.deleteAssetReferences(string);
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        n += this.exitsListDataControl.countIdentifierReferences(string);
        n += this.referencesListDataControl.countIdentifierReferences(string);
        n += this.activeAreasListDataControl.countIdentifierReferences(string);
        n += this.barriersListDataControl.countIdentifierReferences(string);
        return n += this.trajectoryDataControl.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        this.exitsListDataControl.replaceIdentifierReferences(string, string2);
        this.referencesListDataControl.replaceIdentifierReferences(string, string2);
        this.activeAreasListDataControl.replaceIdentifierReferences(string, string2);
        this.barriersListDataControl.replaceIdentifierReferences(string, string2);
        this.trajectoryDataControl.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.exitsListDataControl.deleteIdentifierReferences(string);
        this.referencesListDataControl.deleteIdentifierReferences(string);
        this.activeAreasListDataControl.deleteIdentifierReferences(string);
        this.barriersListDataControl.deleteIdentifierReferences(string);
        this.trajectoryDataControl.deleteIdentifierReferences(string);
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    public TrajectoryDataControl getTrajectory() {
        return this.trajectoryDataControl;
    }

    public void setTrajectoryDataControl(TrajectoryDataControl trajectoryDataControl) {
        this.trajectoryDataControl = trajectoryDataControl;
    }

    public void setTrajectory(Trajectory trajectory) {
        this.scene.setTrajectory(trajectory);
    }

    public void setPlayerLayer(int n) {
        this.scene.setPlayerLayer(n);
    }

    public int getPlayerLayer() {
        return this.scene.getPlayerLayer();
    }

    public void setAllowPlayerLayer(boolean bl) {
        this.scene.setAllowPlayerLayer(bl);
    }

    public boolean isAllowPlayer() {
        return this.scene.isAllowPlayerLayer();
    }

    public void deletePlayerInReferenceList() {
        this.referencesListDataControl.deletePlayer();
    }

    public void addPlayerInReferenceList() {
        this.referencesListDataControl.addPlayer();
    }

    public void changeAllowPlayerLayer(boolean bl, ScenePreviewEditionPanel scenePreviewEditionPanel) {
        Controller.getInstance().addTool(new ChangeAllowPlayerInSceneTool(bl, scenePreviewEditionPanel, this));
    }

    public void insertPlayer() {
        this.deletePlayerInReferenceList();
        this.referencesListDataControl.restorePlayer();
    }

    public void setPlayerScale(float f) {
        Controller.getInstance().addTool(new ChangePlayerScaleTool(this.scene, f));
    }

    public float getPlayerScale() {
        return this.scene.getPlayerScale();
    }

    @Override
    public void recursiveSearch() {
        this.getActiveAreasList().recursiveSearch();
        this.getBarriersList().recursiveSearch();
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getName(), TC.get((String)"Search.Name"));
        this.check(this.getId(), "ID");
        this.getExitsList().recursiveSearch();
        this.getReferencesList().recursiveSearch();
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.resourcesDataControlList);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.exitsListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.referencesListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.activeAreasListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.barriersListDataControl);
        if (list != null) {
            return list;
        }
        return this.getPathFromChild(searchable, this.trajectoryDataControl);
    }
}

