/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReferencesListDataControl
extends DataControl {
    private String playerImagePath;
    private SceneDataControl sceneDataControl;
    private List<ElementReference> itemReferencesList;
    private List<ElementReference> atrezzoReferencesList;
    private List<ElementReference> npcReferencesList;
    private List<ElementContainer> allReferencesDataControl;
    private ElementContainer lastElementContainer;
    private int playerPositionInAllReferences;
    public static final int NO_PLAYER = -1;
    private boolean imagePathHasChanged;

    public ReferencesListDataControl(String string, SceneDataControl sceneDataControl, List<ElementReference> list, List<ElementReference> list2, List<ElementReference> list3) {
        ElementReferenceDataControl elementReferenceDataControl;
        int n;
        this.playerImagePath = string;
        this.sceneDataControl = sceneDataControl;
        this.itemReferencesList = list;
        this.atrezzoReferencesList = list2;
        this.npcReferencesList = list3;
        this.allReferencesDataControl = new ArrayList<ElementContainer>();
        this.lastElementContainer = null;
        this.playerPositionInAllReferences = -1;
        this.imagePathHasChanged = false;
        boolean bl = this.hasLayer();
        for (ElementReference elementReference : list) {
            n = this.count(elementReference);
            elementReferenceDataControl = new ElementReferenceDataControl(sceneDataControl, elementReference, 6, n);
            this.insertInOrder(new ElementContainer(elementReferenceDataControl, -1, null), bl);
        }
        for (ElementReference elementReference : list2) {
            n = this.count(elementReference);
            elementReferenceDataControl = new ElementReferenceDataControl(sceneDataControl, elementReference, 60, n);
            this.insertInOrder(new ElementContainer(elementReferenceDataControl, -1, null), bl);
        }
        for (ElementReference elementReference : list3) {
            n = this.count(elementReference);
            elementReferenceDataControl = new ElementReferenceDataControl(sceneDataControl, elementReference, 8, n);
            this.insertInOrder(new ElementContainer(elementReferenceDataControl, -1, null), bl);
        }
        if (string != null && !Controller.getInstance().isPlayTransparent() && sceneDataControl.isAllowPlayer()) {
            int n2 = sceneDataControl.getPlayerLayer() == -1 ? 0 : sceneDataControl.getPlayerLayer();
            this.reassignLayerAllReferencesDataControl(this.insertInOrder(new ElementContainer(null, n2, AssetsController.getImage(this.playerImagePath)), true));
        }
    }

    private int count(ElementReference elementReference) {
        Iterator<ElementContainer> iterator = this.allReferencesDataControl.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ElementContainer elementContainer = iterator.next();
            if (elementContainer.isPlayer() || !elementContainer.getErdc().getElementId().equals(elementReference.getTargetId())) continue;
            ++n;
        }
        return n;
    }

    private boolean hasLayer() {
        if (!this.itemReferencesList.isEmpty()) {
            return this.itemReferencesList.get(0).getLayer() != -1;
        }
        if (!this.atrezzoReferencesList.isEmpty()) {
            return this.atrezzoReferencesList.get(0).getLayer() != -1;
        }
        if (!this.npcReferencesList.isEmpty()) {
            return this.npcReferencesList.get(0).getLayer() != -1;
        }
        return false;
    }

    public Image getPlayerImage() {
        return AssetsController.getImage(Controller.getInstance().getPlayerImagePath());
    }

    public int insertInOrder(ElementContainer elementContainer, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        int n = 0;
        boolean bl4 = bl2 = this.allReferencesDataControl.size() == 0;
        while (!bl3 && (n < this.allReferencesDataControl.size() || bl2)) {
            if (!bl2) {
                if (bl) {
                    if (elementContainer.getLayer() <= this.allReferencesDataControl.get(n).getLayer()) {
                        this.allReferencesDataControl.add(n, elementContainer);
                        bl3 = true;
                    }
                } else if (elementContainer.getY() <= Math.round(this.allReferencesDataControl.get(n).getY())) {
                    this.allReferencesDataControl.add(n, elementContainer);
                    this.reassignLayerAllReferencesDataControl(n);
                    bl3 = true;
                }
                ++n;
                continue;
            }
            this.allReferencesDataControl.add(n, elementContainer);
            if (!bl) {
                this.reassignLayerAllReferencesDataControl(n);
            }
            bl3 = true;
            ++n;
        }
        if (!bl3) {
            this.allReferencesDataControl.add(elementContainer);
            if (!bl) {
                this.reassignLayerAllReferencesDataControl(n - 1);
            }
        }
        return n - 1;
    }

    public List<ElementContainer> getAllReferencesDataControl() {
        return this.allReferencesDataControl;
    }

    public List<ElementReferenceDataControl> getItemReferences() {
        ArrayList<ElementReferenceDataControl> arrayList = new ArrayList<ElementReferenceDataControl>();
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.getErdc() == null || elementContainer.getErdc().getType() != 6) continue;
            arrayList.add(elementContainer.getErdc());
        }
        return arrayList;
    }

    public List<ElementReferenceDataControl> getAtrezzoReferences() {
        ArrayList<ElementReferenceDataControl> arrayList = new ArrayList<ElementReferenceDataControl>();
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.getErdc() == null || elementContainer.getErdc().getType() != 60) continue;
            arrayList.add(elementContainer.getErdc());
        }
        return arrayList;
    }

    public List<ElementReferenceDataControl> getNPCReferences() {
        ArrayList<ElementReferenceDataControl> arrayList = new ArrayList<ElementReferenceDataControl>();
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.getErdc() == null || elementContainer.getErdc().getType() != 8) continue;
            arrayList.add(elementContainer.getErdc());
        }
        return arrayList;
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    @Override
    public Object getContent() {
        return this.itemReferencesList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{6, 60, 8};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 6 || n == 60 || n == 8;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        ElementContainer elementContainer;
        ElementReferenceDataControl elementReferenceDataControl;
        int n2;
        ElementReference elementReference;
        String string2;
        Object[] objectArray;
        boolean bl = false;
        if (n == 6) {
            objectArray = this.controller.getIdentifierSummary().getItemIds();
            if (objectArray.length > 0) {
                string2 = this.controller.showInputDialog(TC.get((String)"Operation.AddItemReferenceTitle"), TC.get((String)"Operation.AddItemReferenceMessage"), objectArray);
                if (string2 != null) {
                    elementReference = new ElementReference(string2, 50, 50);
                    n2 = this.count(elementReference);
                    elementReferenceDataControl = new ElementReferenceDataControl(this.sceneDataControl, elementReference, n, n2);
                    this.itemReferencesList.add(elementReference);
                    this.lastElementContainer = elementContainer = new ElementContainer(elementReferenceDataControl, -1, null);
                    this.reassignLayerAllReferencesDataControl(this.insertInOrder(elementContainer, false));
                    bl = true;
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Operation.AddItemReferenceTitle"), TC.get((String)"Operation.AddItemReferenceErrorNoItems"));
            }
        }
        if (n == 60) {
            objectArray = this.controller.getIdentifierSummary().getAtrezzoIds();
            if (objectArray.length > 0) {
                string2 = this.controller.showInputDialog(TC.get((String)"Operation.AddAtrezzoReferenceTitle"), TC.get((String)"Operation.AddAtrezzoReferenceMessage"), objectArray);
                if (string2 != null) {
                    elementReference = new ElementReference(string2, 50, 50);
                    n2 = this.count(elementReference);
                    elementReferenceDataControl = new ElementReferenceDataControl(this.sceneDataControl, elementReference, n, n2);
                    this.atrezzoReferencesList.add(elementReference);
                    this.lastElementContainer = elementContainer = new ElementContainer(elementReferenceDataControl, -1, null);
                    this.reassignLayerAllReferencesDataControl(this.insertInOrder(elementContainer, false));
                    bl = true;
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Operation.AddAtrezzoReferenceTitle"), TC.get((String)"Operation.AddReferenceErrorNoAtrezzo"));
            }
        }
        if (n == 8) {
            objectArray = this.controller.getIdentifierSummary().getNPCIds();
            if (objectArray.length > 0) {
                string2 = this.controller.showInputDialog(TC.get((String)"Operation.AddNPCReferenceTitle"), TC.get((String)"Operation.AddNPCReferenceMessage"), objectArray);
                if (string2 != null) {
                    elementReference = new ElementReference(string2, 50, 50);
                    n2 = this.count(elementReference);
                    elementReferenceDataControl = new ElementReferenceDataControl(this.sceneDataControl, elementReference, n, n2);
                    this.npcReferencesList.add(elementReference);
                    this.lastElementContainer = elementContainer = new ElementContainer(elementReferenceDataControl, -1, null);
                    this.reassignLayerAllReferencesDataControl(this.insertInOrder(elementContainer, false));
                    bl = true;
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Operation.AddNPCReferenceTitle"), TC.get((String)"Operation.AddReferenceErrorNoNPC"));
            }
        }
        return bl;
    }

    private void reassignLayerAllReferencesDataControl(int n) {
        for (int i = n; i < this.allReferencesDataControl.size(); ++i) {
            this.allReferencesDataControl.get(i).setLayer(i);
            if (!this.allReferencesDataControl.get(i).isPlayer()) continue;
            this.playerPositionInAllReferences = i;
        }
    }

    private void delete(DataControl dataControl) {
        if (dataControl != null) {
            int n = 0;
            for (n = 0; n < this.allReferencesDataControl.size() && (this.allReferencesDataControl.get(n).isPlayer() || !this.allReferencesDataControl.get(n).getErdc().equals(dataControl)); ++n) {
            }
            if (n >= 0 && n < this.allReferencesDataControl.size()) {
                this.allReferencesDataControl.remove(n);
                this.reassignLayerAllReferencesDataControl(n);
            }
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        if (dataControl != null) {
            this.itemReferencesList.remove(dataControl.getContent());
            this.atrezzoReferencesList.remove(dataControl.getContent());
            this.npcReferencesList.remove(dataControl.getContent());
            this.delete(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    public void addElement(ElementContainer elementContainer) {
        if (elementContainer.getErdc().getType() == 6) {
            this.itemReferencesList.add((ElementReference)elementContainer.getErdc().getContent());
        } else if (elementContainer.getErdc().getType() == 60) {
            this.atrezzoReferencesList.add((ElementReference)elementContainer.getErdc().getContent());
        } else if (elementContainer.getErdc().getType() == 8) {
            this.npcReferencesList.add((ElementReference)elementContainer.getErdc().getContent());
        }
        this.allReferencesDataControl.add(elementContainer.getLayer(), elementContainer);
        this.reassignLayerAllReferencesDataControl(elementContainer.getLayer());
    }

    private void moveUp(DataControl dataControl) {
        boolean bl;
        int n = 0;
        if (dataControl != null) {
            bl = false;
            for (n = 0; n < this.allReferencesDataControl.size() && (this.allReferencesDataControl.get(n).isPlayer() || !this.allReferencesDataControl.get(n).getErdc().equals(dataControl)); ++n) {
            }
        } else {
            n = this.playerPositionInAllReferences;
            bl = true;
        }
        if (n > 0) {
            this.allReferencesDataControl.add(n - 1, this.allReferencesDataControl.remove(n));
            this.allReferencesDataControl.get(n).setLayer(n);
            this.allReferencesDataControl.get(n - 1).setLayer(n - 1);
            if (bl) {
                this.setPlayerPosition(n - 1);
            }
            if (this.allReferencesDataControl.get(n).isPlayer()) {
                this.setPlayerPosition(n);
            }
        }
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        if (dataControl != null) {
            this.moveUp(dataControl);
            bl = true;
        } else {
            this.moveUp(dataControl);
            bl = true;
        }
        return bl;
    }

    private void moveDown(DataControl dataControl) {
        boolean bl;
        int n = 0;
        if (dataControl != null) {
            bl = false;
            for (n = 0; n < this.allReferencesDataControl.size() && (this.allReferencesDataControl.get(n).isPlayer() || !this.allReferencesDataControl.get(n).getErdc().equals(dataControl)); ++n) {
            }
        } else {
            n = this.playerPositionInAllReferences;
            bl = true;
        }
        if (n >= 0 && n < this.allReferencesDataControl.size() - 1) {
            this.allReferencesDataControl.add(n + 1, this.allReferencesDataControl.remove(n));
            this.allReferencesDataControl.get(n).setLayer(n);
            this.allReferencesDataControl.get(n + 1).setLayer(n + 1);
            if (bl) {
                this.setPlayerPosition(n + 1);
            }
            if (this.allReferencesDataControl.get(n).isPlayer()) {
                this.setPlayerPosition(n);
            }
        }
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        if (dataControl != null) {
            this.moveDown(dataControl);
            bl = true;
        } else {
            this.moveDown(dataControl);
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.isPlayer()) continue;
            elementContainer.getErdc().updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.isPlayer()) continue;
            n += elementContainer.getErdc().countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.isPlayer()) continue;
            elementContainer.getErdc().replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.deleteIdentifierFromReferenceList(this.itemReferencesList, string);
        this.deleteIdentifierFromReferenceList(this.atrezzoReferencesList, string);
        this.deleteIdentifierFromReferenceList(this.npcReferencesList, string);
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.getErdc() == null) continue;
            elementContainer.getErdc().deleteIdentifierReferences(string);
        }
    }

    private void deleteIdentifierFromReferenceList(List<ElementReference> list, String string) {
        int n = 0;
        while (n < list.size()) {
            if (list.get(n).getTargetId().equals(string)) {
                this.deleteReferenceFromAll(list.get(n));
                list.remove(n);
                continue;
            }
            ++n;
        }
    }

    private void deleteReferenceFromAll(Object object) {
        int n = 0;
        while (n < this.allReferencesDataControl.size()) {
            ElementContainer elementContainer = this.allReferencesDataControl.get(n);
            if (!elementContainer.isPlayer() && elementContainer.getErdc().getContent() == object) {
                this.allReferencesDataControl.remove(n);
                continue;
            }
            ++n;
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public boolean containsDataControl(ElementReferenceDataControl elementReferenceDataControl) {
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.isPlayer() || elementContainer.getErdc() != elementReferenceDataControl) continue;
            return true;
        }
        return false;
    }

    public ElementContainer getLastElementContainer() {
        return this.lastElementContainer;
    }

    public void setLastElementContainer(ElementContainer elementContainer) {
        this.lastElementContainer = elementContainer;
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    public String[] getAllReferencesId() {
        String[] stringArray = new String[this.allReferencesDataControl.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.allReferencesDataControl.get(i).isPlayer() ? "Player" : this.allReferencesDataControl.get(i).getErdc().getElementId();
        }
        return stringArray;
    }

    public int getPlayerPosition() {
        return this.playerPositionInAllReferences;
    }

    public void setPlayerPosition(int n) {
        this.playerPositionInAllReferences = n;
        this.sceneDataControl.setPlayerLayer(n);
    }

    public void deletePlayer() {
        if (this.playerPositionInAllReferences != -1) {
            this.allReferencesDataControl.remove(this.playerPositionInAllReferences);
            this.reassignLayerAllReferencesDataControl(this.playerPositionInAllReferences);
            this.playerPositionInAllReferences = -1;
            this.playerImagePath = null;
            this.sceneDataControl.setPlayerLayer(-2);
        }
    }

    public void restorePlayer() {
        ElementContainer elementContainer = new ElementContainer(null, this.sceneDataControl.getPlayerLayer(), AssetsController.getImage(this.playerImagePath));
        int n = this.insertInOrder(elementContainer, true);
        this.reassignLayerAllReferencesDataControl(n);
    }

    public void addPlayer() {
        if (this.sceneDataControl.isAllowPlayer()) {
            this.playerImagePath = Controller.getInstance().getPlayerImagePath();
            ElementContainer elementContainer = new ElementContainer(null, 0, AssetsController.getImage(this.playerImagePath));
            int n = this.insertInOrder(elementContainer, true);
            this.reassignLayerAllReferencesDataControl(n);
            this.sceneDataControl.setPlayerLayer(n);
        }
    }

    public void changeImagePlayerPath(String string) {
        this.playerImagePath = string;
        this.imagePathHasChanged = true;
        if (this.allReferencesDataControl.size() == 0) {
            this.playerPositionInAllReferences = 0;
            this.reassignLayerAllReferencesDataControl(this.insertInOrder(new ElementContainer(null, 0, AssetsController.getImage(this.playerImagePath)), true));
        }
    }

    @Override
    public void recursiveSearch() {
        if (this.getAtrezzoReferences() != null) {
            for (ElementReferenceDataControl elementReferenceDataControl : this.getAtrezzoReferences()) {
                ((Searchable)elementReferenceDataControl).recursiveSearch();
            }
        }
        if (this.getItemReferences() != null) {
            for (ElementReferenceDataControl elementReferenceDataControl : this.getItemReferences()) {
                ((Searchable)elementReferenceDataControl).recursiveSearch();
            }
        }
        if (this.getNPCReferences() != null) {
            for (ElementReferenceDataControl elementReferenceDataControl : this.getNPCReferences()) {
                ((Searchable)elementReferenceDataControl).recursiveSearch();
            }
        }
    }

    public void setPlayerPositionInAllReferences(int n) {
        this.playerPositionInAllReferences = n;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        ArrayList<ElementReferenceDataControl> arrayList = new ArrayList<ElementReferenceDataControl>();
        for (ElementContainer elementContainer : this.allReferencesDataControl) {
            if (elementContainer.getErdc() == null) continue;
            arrayList.add(elementContainer.getErdc());
        }
        return this.getPathFromChild(searchable, arrayList);
    }

    public static int transformType(int n) {
        int n2 = 0;
        if (n == 6) {
            n2 = 1;
        } else if (n == 60) {
            n2 = 3;
        } else if (n == 8) {
            n2 = 2;
        } else if (n == -1) {
            n2 = 6;
        }
        return n2;
    }
}

