/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ExitsListDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private List<Exit> exitsList;
    private List<ExitDataControl> exitsDataControlList;

    public ExitsListDataControl(SceneDataControl sceneDataControl, List<Exit> list) {
        this.sceneDataControl = sceneDataControl;
        this.exitsList = list;
        this.exitsDataControlList = new ArrayList<ExitDataControl>();
        for (Exit exit : list) {
            this.exitsDataControlList.add(new ExitDataControl(sceneDataControl, exit));
        }
    }

    public List<ExitDataControl> getExits() {
        return this.exitsDataControlList;
    }

    public ExitDataControl getLastExit() {
        return this.exitsDataControlList.get(this.exitsDataControlList.size() - 1);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    @Override
    public Object getContent() {
        return this.exitsList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{4};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 4;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        String string2;
        Object[] objectArray;
        boolean bl = false;
        if (n == 4 && (objectArray = this.controller.getIdentifierSummary().getGeneralSceneIds()).length > 0 && (string2 = this.controller.showInputDialog(TC.get((String)"Operation.AddNextSceneTitle"), TC.get((String)"Operation.AddNextSceneMessage"), objectArray)) != null) {
            Exit exit = new Exit(true, 240, 240, 100, 100);
            exit.setNextSceneId(string2);
            ExitDataControl exitDataControl = new ExitDataControl(this.sceneDataControl, exit);
            this.exitsList.add(exit);
            this.exitsDataControlList.add(exitDataControl);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof ExitDataControl)) {
            return false;
        }
        try {
            Exit exit = (Exit)((Exit)dataControl.getContent()).clone();
            this.exitsList.add(exit);
            this.exitsDataControlList.add(new ExitDataControl(this.sceneDataControl, exit));
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone exit");
            return false;
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        if (this.exitsList.remove(dataControl.getContent())) {
            this.exitsDataControlList.remove(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.exitsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.exitsList.add(n - 1, this.exitsList.remove(n));
            this.exitsDataControlList.add(n - 1, this.exitsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.exitsList.indexOf(dataControl.getContent());
        if (n < this.exitsList.size() - 1) {
            this.exitsList.add(n + 1, this.exitsList.remove(n));
            this.exitsDataControlList.add(n + 1, this.exitsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            exitDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.exitsDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)4) + " #" + (i + 1);
            bl &= this.exitsDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            n += exitDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            exitDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            exitDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            n += exitDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            exitDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            exitDataControl.deleteIdentifierReferences(string);
        }
        int n = 0;
        while (n < this.exitsList.size()) {
            if (this.exitsList.get(n).getNextSceneId() == null) {
                this.exitsList.remove(n);
                this.exitsDataControlList.remove(n);
                continue;
            }
            ++n;
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public List<ElementReferenceDataControl> getParentSceneItemReferences() {
        return this.sceneDataControl.getReferencesList().getItemReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneNPCReferences() {
        return this.sceneDataControl.getReferencesList().getNPCReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneAtrezzoReferences() {
        return this.sceneDataControl.getReferencesList().getAtrezzoReferences();
    }

    public List<BarrierDataControl> getParentSceneBarriers() {
        return this.sceneDataControl.getBarriersList().getBarriers();
    }

    public List<ActiveAreaDataControl> getParentSceneActiveAreas() {
        return this.sceneDataControl.getActiveAreasList().getActiveAreas();
    }

    @Override
    public void recursiveSearch() {
        for (ExitDataControl exitDataControl : this.exitsDataControlList) {
            ((Searchable)exitDataControl).recursiveSearch();
        }
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.exitsDataControlList);
    }

    public List<Exit> getExitsList() {
        return this.exitsList;
    }
}

