/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ExitLookDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.RectangleArea;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeNSDestinyPositionTool;
import es.eucm.eadventure.editor.control.tools.general.ChangeRectangleValueTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.AddNewPointTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.ChangeRectangularValueTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.DeletePointTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeIntegerValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;

public class ExitDataControl
extends DataControl
implements RectangleArea {
    private SceneDataControl sceneDataControl;
    private Exit exit;
    private ConditionsController conditionsController;
    private ExitLookDataControl exitLookDataControl;
    private InfluenceAreaDataControl influenceAreaDataControl;
    private EffectsController effectsController;
    private EffectsController postEffectsController;
    private EffectsController notEffectsController;

    public ExitDataControl(SceneDataControl sceneDataControl, Exit exit) {
        this.sceneDataControl = sceneDataControl;
        this.exit = exit;
        this.influenceAreaDataControl = new InfluenceAreaDataControl(sceneDataControl, exit.getInfluenceArea(), this);
        this.effectsController = new EffectsController(exit.getEffects());
        this.postEffectsController = new EffectsController(exit.getPostEffects());
        this.notEffectsController = new EffectsController(exit.getNotEffects());
        this.conditionsController = new ConditionsController(new Conditions());
        this.exitLookDataControl = new ExitLookDataControl(exit);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    public int getX() {
        return this.exit.getX();
    }

    public int getY() {
        return this.exit.getY();
    }

    public int getWidth() {
        return this.exit.getWidth();
    }

    public int getHeight() {
        return this.exit.getHeight();
    }

    public String getDocumentation() {
        return this.exit.getDocumentation();
    }

    public void setExit(int n, int n2, int n3, int n4) {
        this.controller.addTool(new ChangeRectangleValueTool((Rectangle)this.exit, n, n2, n3, n4));
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.exit, string));
    }

    @Override
    public Object getContent() {
        return this.exit;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.exit.getConditions());
        if (this.exit.getEffects() != null) {
            EffectsController.updateVarFlagSummary(varFlagSummary, this.exit.getEffects());
        }
        if (this.exit.getPostEffects() != null) {
            EffectsController.updateVarFlagSummary(varFlagSummary, this.exit.getPostEffects());
        }
        if (this.exit.getNotEffects() != null) {
            EffectsController.updateVarFlagSummary(varFlagSummary, this.exit.getNotEffects());
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        return this.exitLookDataControl.countAssetReferences(string);
    }

    @Override
    public void deleteAssetReferences(String string) {
        this.exitLookDataControl.deleteAssetReferences(string);
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (string.equals(this.exit.getNextSceneId())) {
            n = 1;
        }
        n += EffectsController.countIdentifierReferences(string, this.exit.getEffects());
        n += EffectsController.countIdentifierReferences(string, this.exit.getPostEffects());
        n += EffectsController.countIdentifierReferences(string, this.exit.getNotEffects());
        return n += this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (string.equals(this.exit.getNextSceneId())) {
            this.exit.setNextSceneId(string2);
        }
        EffectsController.replaceIdentifierReferences(string, string2, this.exit.getEffects());
        EffectsController.replaceIdentifierReferences(string, string2, this.exit.getPostEffects());
        EffectsController.replaceIdentifierReferences(string, string2, this.exit.getNotEffects());
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        EffectsController.deleteIdentifierReferences(string, this.exit.getEffects());
        EffectsController.deleteIdentifierReferences(string, this.exit.getPostEffects());
        EffectsController.deleteIdentifierReferences(string, this.exit.getNotEffects());
        this.conditionsController.deleteIdentifierReferences(string);
        if (string.equals(this.exit.getNextSceneId())) {
            this.exit.setNextSceneId(null);
        }
    }

    public ExitLookDataControl getExitLookDataControl() {
        return this.exitLookDataControl;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.exitLookDataControl.getAssetReferences(list, list2);
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getExitLookDataControl().getCustomizedText(), TC.get((String)"Search.CustomizedText"));
    }

    @Override
    public boolean isRectangular() {
        return this.exit.isRectangular();
    }

    @Override
    public List<Point> getPoints() {
        return this.exit.getPoints();
    }

    @Override
    public void addPoint(int n, int n2) {
        this.controller.addTool(new AddNewPointTool((Rectangle)this.exit, n, n2));
    }

    @Override
    public Point getLastPoint() {
        if (this.exit.getPoints().size() > 0) {
            return (Point)this.exit.getPoints().get(this.exit.getPoints().size() - 1);
        }
        return null;
    }

    @Override
    public void deletePoint(Point point) {
        this.controller.addTool(new DeletePointTool((Rectangle)this.exit, point));
    }

    @Override
    public void setRectangular(boolean bl) {
        this.controller.addTool(new ChangeRectangularValueTool((Rectangle)this.exit, bl));
    }

    @Override
    public Rectangle getRectangle() {
        return (Rectangle)this.getContent();
    }

    public InfluenceAreaDataControl getInfluenceArea() {
        return this.influenceAreaDataControl;
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    public ConditionsController getConditions() {
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
        ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(2, this.sceneDataControl.getId());
        ConditionsController.ConditionOwner conditionOwner2 = new ConditionsController.ConditionOwner(4, this.exit.getNextSceneId(), conditionOwner);
        hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner2);
        this.conditionsController = new ConditionsController(this.exit.getConditions(), hashMap);
        return this.conditionsController;
    }

    public String getNextSceneId() {
        return this.exit.getNextSceneId();
    }

    public void setNextSceneId(String string) {
        Controller.getInstance().addTool(new ChangeStringValueTool(this.exit, string, "getNextSceneId", "setNextSceneId"));
    }

    public int getDestinyPositionX() {
        return this.exit.getDestinyX();
    }

    public int getDestinyPositionY() {
        return this.exit.getDestinyY();
    }

    public void setDestinyPosition(int n, int n2) {
        this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.exit, n, n2));
    }

    public void toggleDestinyPosition() {
        if (this.exit.hasPlayerPosition()) {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.exit, Integer.MIN_VALUE, Integer.MIN_VALUE));
        } else {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.exit, 0, 0));
        }
    }

    public boolean hasDestinyPosition() {
        return this.exit.hasPlayerPosition();
    }

    public int getTransitionType() {
        return this.exit.getTransitionType();
    }

    public Number getTransitionTime() {
        return this.exit.getTransitionTime();
    }

    public void setTransitionTime(int n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.exit, n, "getTransitionTime", "setTransitionTime"));
    }

    public void setTransitionType(int n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.exit, n, "getTransitionType", "setTransitionType"));
    }

    public boolean isHasNotEffects() {
        return this.exit.isHasNotEffects();
    }

    public void setHasNotEffects(boolean bl) {
        Controller.getInstance().addTool(new ChangeBooleanValueTool(this.exit, bl, "isHasNotEffects", "setHasNotEffects"));
    }

    public EffectsController getEffects() {
        return this.effectsController;
    }

    public EffectsController getPostEffects() {
        return this.postEffectsController;
    }

    public EffectsController getNotEffects() {
        return this.notEffectsController;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

