/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.atrezzo.AtrezzoDataControl;
import es.eucm.eadventure.editor.control.controllers.atrezzo.AtrezzoListDataControl;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.character.NPCsListDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemsListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeElementReferenceTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.HashMap;
import java.util.List;

public class ElementReferenceDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private ElementReference elementReference;
    private InfluenceAreaDataControl influenceAreaDataControl;
    private ConditionsController conditionsController;
    private int type;
    private boolean visible;

    public ElementReferenceDataControl(SceneDataControl sceneDataControl, ElementReference elementReference, int n, int n2) {
        this.sceneDataControl = sceneDataControl;
        this.elementReference = elementReference;
        this.type = n;
        this.visible = true;
        if (n == 6 || n == 8) {
            this.influenceAreaDataControl = new InfluenceAreaDataControl(sceneDataControl, elementReference.getInfluenceArea(), this);
        }
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
        ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(2, sceneDataControl.getId());
        ConditionsController.ConditionOwner conditionOwner2 = new ConditionsController.ConditionOwner(n, elementReference.getTargetId(), conditionOwner);
        hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner2);
        this.conditionsController = new ConditionsController(elementReference.getConditions(), hashMap);
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    public List<ElementReferenceDataControl> getParentSceneItemReferences() {
        return this.sceneDataControl.getReferencesList().getItemReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneNPCReferences() {
        return this.sceneDataControl.getReferencesList().getNPCReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneAtrezzoReferences() {
        return this.sceneDataControl.getReferencesList().getAtrezzoReferences();
    }

    public List<ExitDataControl> getParentSceneExitList() {
        return this.sceneDataControl.getExitsList().getExits();
    }

    public List<ActiveAreaDataControl> getParentSceneActiveAreaList() {
        return this.sceneDataControl.getActiveAreasList().getActiveAreas();
    }

    public List<BarrierDataControl> getParentSceneBarrierList() {
        return this.sceneDataControl.getBarriersList().getBarriers();
    }

    public String getElementId() {
        return this.elementReference.getTargetId();
    }

    public int getElementX() {
        return this.elementReference.getX();
    }

    public int getElementY() {
        return this.elementReference.getY();
    }

    public String getDocumentation() {
        return this.elementReference.getDocumentation();
    }

    public void setElementId(String string) {
        this.controller.addTool(new ChangeTargetIdTool((HasTargetId)this.elementReference, string));
    }

    public void setElementPosition(int n, int n2) {
        this.controller.addTool(new ChangeElementReferenceTool(this.elementReference, n, n2));
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.elementReference, string));
    }

    public float getElementScale() {
        return this.elementReference.getScale();
    }

    public void setElementScale(float f) {
        this.controller.addTool(new ChangeElementReferenceTool(this.elementReference, f));
    }

    @Override
    public Object getContent() {
        return this.elementReference;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.elementReference.getConditions());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        n += this.elementReference.getTargetId().equals(string) ? 1 : 0;
        return n += this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.elementReference.getTargetId().equals(string)) {
            this.elementReference.setTargetId(string2);
        }
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.conditionsController.deleteIdentifierReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public ElementReference getElementReference() {
        return this.elementReference;
    }

    public int getType() {
        return this.type;
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    public InfluenceAreaDataControl getInfluenceArea() {
        return this.influenceAreaDataControl;
    }

    public DataControl getReferencedElementDataControl() {
        switch (this.type) {
            case 60: {
                AtrezzoListDataControl atrezzoListDataControl = Controller.getInstance().getSelectedChapterDataControl().getAtrezzoList();
                for (AtrezzoDataControl atrezzoDataControl : atrezzoListDataControl.getAtrezzoList()) {
                    if (!atrezzoDataControl.getId().equals(this.getElementId())) continue;
                    return atrezzoDataControl;
                }
                break;
            }
            case 8: {
                NPCsListDataControl nPCsListDataControl = Controller.getInstance().getSelectedChapterDataControl().getNPCsList();
                for (NPCDataControl nPCDataControl : nPCsListDataControl.getNPCs()) {
                    if (!nPCDataControl.getId().equals(this.getElementId())) continue;
                    return nPCDataControl;
                }
                break;
            }
            case 6: {
                ItemsListDataControl itemsListDataControl = Controller.getInstance().getSelectedChapterDataControl().getItemsList();
                for (ItemDataControl itemDataControl : itemsListDataControl.getItems()) {
                    if (!itemDataControl.getId().equals(this.getElementId())) continue;
                    return itemDataControl;
                }
                break;
            }
        }
        return null;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.conditionsController, TC.get((String)"Search.Conditions"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getElementId(), TC.get((String)"Search.ElementID"));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

