/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import java.awt.Image;

public class ElementContainer {
    private ElementReferenceDataControl erdc;
    private int playerLayer;
    private Image image;

    public ElementContainer(ElementReferenceDataControl elementReferenceDataControl, int n, Image image) {
        if (elementReferenceDataControl != null) {
            this.erdc = elementReferenceDataControl;
            this.playerLayer = -1;
            this.image = null;
        } else {
            this.playerLayer = n;
            this.image = image;
        }
    }

    public void setImage(Image image) {
        Controller.getInstance().dataModified();
        this.image = image;
    }

    public int getLayer() {
        if (this.erdc == null) {
            return this.playerLayer;
        }
        return this.erdc.getElementReference().getLayer();
    }

    public int getY() {
        if (this.erdc == null) {
            return this.playerLayer;
        }
        return this.erdc.getElementReference().getY();
    }

    public void setLayer(int n) {
        Controller.getInstance().dataModified();
        if (this.erdc == null) {
            this.playerLayer = n;
        } else {
            this.erdc.getElementReference().setLayer(n);
        }
    }

    public boolean isPlayer() {
        return this.erdc == null;
    }

    public int getPlayerLayer() {
        return this.playerLayer;
    }

    public ElementReferenceDataControl getErdc() {
        return this.erdc;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isVisible() {
        if (this.erdc == null) {
            return true;
        }
        return this.erdc.isVisible();
    }

    public void setVisible(boolean bl) {
        if (this.erdc != null) {
            Controller.getInstance().dataModified();
            this.erdc.setVisible(bl);
        }
    }
}

