/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class BarriersListDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private List<Barrier> barriersList;
    private List<BarrierDataControl> barriersDataControlList;
    private int id = 0;

    public BarriersListDataControl(SceneDataControl sceneDataControl, List<Barrier> list) {
        this.sceneDataControl = sceneDataControl;
        this.barriersList = list;
        this.barriersDataControlList = new ArrayList<BarrierDataControl>();
        for (Barrier barrier : list) {
            this.barriersDataControlList.add(new BarrierDataControl(sceneDataControl, barrier));
        }
        this.id = list.size() + 1;
    }

    public List<BarrierDataControl> getBarriers() {
        return this.barriersDataControlList;
    }

    public BarrierDataControl getLastBarrier() {
        return this.barriersDataControlList.get(this.barriersDataControlList.size() - 1);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    @Override
    public Object getContent() {
        return this.barriersList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{53};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 53;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 53) {
            Barrier barrier = new Barrier(string, 200, 200, 100, 100);
            ++this.id;
            BarrierDataControl barrierDataControl = new BarrierDataControl(this.sceneDataControl, barrier);
            this.barriersList.add(barrier);
            this.barriersDataControlList.add(barrierDataControl);
            bl = true;
        }
        return bl;
    }

    public String getDefaultId() {
        return Integer.toString(this.id);
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof BarrierDataControl)) {
            return false;
        }
        try {
            Barrier barrier = (Barrier)((Barrier)dataControl.getContent()).clone();
            barrier.setId(Integer.toString(this.id));
            ++this.id;
            this.barriersList.add(barrier);
            this.barriersDataControlList.add(new BarrierDataControl(this.sceneDataControl, barrier));
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone barrier");
            return false;
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        if (this.barriersList.remove(dataControl.getContent())) {
            this.barriersDataControlList.remove(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.barriersList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.barriersList.add(n - 1, this.barriersList.remove(n));
            this.barriersDataControlList.add(n - 1, this.barriersDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.barriersList.indexOf(dataControl.getContent());
        if (n < this.barriersList.size() - 1) {
            this.barriersList.add(n + 1, this.barriersList.remove(n));
            this.barriersDataControlList.add(n + 1, this.barriersDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            barrierDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.barriersDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)53) + " #" + (i + 1);
            bl &= this.barriersDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            n += barrierDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            barrierDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            barrierDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            n += barrierDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            barrierDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            barrierDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public TrajectoryDataControl getTrajectoryDataControl() {
        return this.sceneDataControl.getTrajectory();
    }

    public List<ElementReferenceDataControl> getParentSceneItemReferences() {
        return this.sceneDataControl.getReferencesList().getItemReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneNPCReferences() {
        return this.sceneDataControl.getReferencesList().getNPCReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneAtrezzoReferences() {
        return this.sceneDataControl.getReferencesList().getAtrezzoReferences();
    }

    public List<ExitDataControl> getParentSceneExits() {
        return this.sceneDataControl.getExitsList().getExits();
    }

    public List<ActiveAreaDataControl> getParentSceneActiveAreas() {
        return this.sceneDataControl.getActiveAreasList().getActiveAreas();
    }

    @Override
    public void recursiveSearch() {
        for (BarrierDataControl barrierDataControl : this.barriersDataControlList) {
            ((Searchable)barrierDataControl).recursiveSearch();
        }
    }

    public TrajectoryDataControl getParentSceneTrajectory() {
        return this.sceneDataControl.getTrajectory();
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.barriersDataControlList);
    }

    public List<Barrier> getBarriersList() {
        return this.barriersList;
    }
}

