/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeRectangleValueTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDetailedDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.HashMap;
import java.util.List;

public class BarrierDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private Barrier barrier;
    private ConditionsController conditionsController;

    public BarrierDataControl(SceneDataControl sceneDataControl, Barrier barrier) {
        this.sceneDataControl = sceneDataControl;
        this.barrier = barrier;
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
        ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(2, sceneDataControl.getId());
        ConditionsController.ConditionOwner conditionOwner2 = new ConditionsController.ConditionOwner(53, barrier.getId(), conditionOwner);
        hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner2);
        this.conditionsController = new ConditionsController(barrier.getConditions(), hashMap);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    public String getId() {
        return this.barrier.getId();
    }

    public String getDocumentation() {
        return this.barrier.getDocumentation();
    }

    public String getName() {
        return this.barrier.getName();
    }

    public String getBriefDescription() {
        return this.barrier.getDescription();
    }

    public String getDetailedDescription() {
        return this.barrier.getDetailedDescription();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.barrier, string));
    }

    public void setName(String string) {
        this.controller.addTool(new ChangeNameTool((Named)this.barrier, string));
    }

    public void setBriefDescription(String string) {
        this.controller.addTool(new ChangeDescriptionTool((Described)this.barrier, string));
    }

    public void setDetailedDescription(String string) {
        this.controller.addTool(new ChangeDetailedDescriptionTool((Detailed)this.barrier, string));
    }

    public int getX() {
        return this.barrier.getX();
    }

    public int getY() {
        return this.barrier.getY();
    }

    public int getWidth() {
        return this.barrier.getWidth();
    }

    public int getHeight() {
        return this.barrier.getHeight();
    }

    public void setBarrier(int n, int n2, int n3, int n4) {
        this.controller.addTool(new ChangeRectangleValueTool((Rectangle)this.barrier, n, n2, n3, n4));
    }

    @Override
    public Object getContent() {
        return this.barrier;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.barrier.getConditions());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        return this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.conditionsController.deleteIdentifierReferences(string);
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getBriefDescription(), TC.get((String)"Search.BriefDescription"));
        this.check(this.getConditions(), TC.get((String)"Search.Conditions"));
        this.check(this.getDetailedDescription(), TC.get((String)"Search.DetailedDescription"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        this.check(this.getName(), TC.get((String)"Search.Name"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

