/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ActiveAreasListDataControl
extends DataControl {
    private SceneDataControl sceneDataControl;
    private List<ActiveArea> activeAreasList;
    private List<ActiveAreaDataControl> activeAreasDataControlList;

    public ActiveAreasListDataControl(SceneDataControl sceneDataControl, List<ActiveArea> list) {
        this.sceneDataControl = sceneDataControl;
        this.activeAreasList = list;
        this.activeAreasDataControlList = new ArrayList<ActiveAreaDataControl>();
        for (ActiveArea activeArea : list) {
            this.activeAreasDataControlList.add(new ActiveAreaDataControl(sceneDataControl, activeArea));
        }
    }

    public List<ActiveAreaDataControl> getActiveAreas() {
        return this.activeAreasDataControlList;
    }

    public ActiveAreaDataControl getLastActiveArea() {
        return this.activeAreasDataControlList.get(this.activeAreasDataControlList.size() - 1);
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    @Override
    public Object getContent() {
        return this.activeAreasList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{51};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 51;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 51) {
            String string2 = string;
            if (string == null) {
                string2 = this.controller.showInputDialog(TC.get((String)"Operation.AddItemTitle"), TC.get((String)"Operation.AddItemMessage"), TC.get((String)"Operation.AddItemDefaultValue"));
            }
            if (string2 != null && this.controller.isElementIdValid(string2)) {
                ActiveArea activeArea = new ActiveArea(string2, true, 220, 220, 100, 100);
                this.activeAreasList.add(activeArea);
                ActiveAreaDataControl activeAreaDataControl = new ActiveAreaDataControl(this.sceneDataControl, activeArea);
                this.activeAreasDataControlList.add(activeAreaDataControl);
                this.controller.getIdentifierSummary().addActiveAreaId(string2);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String getDefaultId(int n) {
        return "IdObject";
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof ActiveAreaDataControl)) {
            return false;
        }
        try {
            String string;
            ActiveArea activeArea = (ActiveArea)((ActiveArea)dataControl.getContent()).clone();
            int n = 1;
            do {
                string = this.getDefaultId(0) + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            activeArea.setId(string);
            this.activeAreasList.add(activeArea);
            this.activeAreasDataControlList.add(new ActiveAreaDataControl(this.sceneDataControl, activeArea));
            this.controller.getIdentifierSummary().addActiveAreaId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone activeArea");
            return false;
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((ActiveAreaDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.activeAreasList.remove(dataControl.getContent())) {
            this.activeAreasDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteActiveAreaId(((ActiveArea)dataControl.getContent()).getId());
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.activeAreasList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.activeAreasList.add(n - 1, this.activeAreasList.remove(n));
            this.activeAreasDataControlList.add(n - 1, this.activeAreasDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.activeAreasList.indexOf(dataControl.getContent());
        if (n < this.activeAreasList.size() - 1) {
            this.activeAreasList.add(n + 1, this.activeAreasList.remove(n));
            this.activeAreasDataControlList.add(n + 1, this.activeAreasDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            activeAreaDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.activeAreasDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)51) + " #" + (i + 1);
            bl &= this.activeAreasDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            n += activeAreaDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            activeAreaDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            activeAreaDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            n += activeAreaDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            activeAreaDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            activeAreaDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public List<ElementReferenceDataControl> getParentSceneItemReferences() {
        return this.sceneDataControl.getReferencesList().getItemReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneNPCReferences() {
        return this.sceneDataControl.getReferencesList().getNPCReferences();
    }

    public List<ElementReferenceDataControl> getParentSceneAtrezzoReferences() {
        return this.sceneDataControl.getReferencesList().getAtrezzoReferences();
    }

    public List<ExitDataControl> getParentSceneExits() {
        return this.sceneDataControl.getExitsList().getExits();
    }

    public List<BarrierDataControl> getParentSceneBarriers() {
        return this.sceneDataControl.getBarriersList().getBarriers();
    }

    @Override
    public void recursiveSearch() {
        for (ActiveAreaDataControl activeAreaDataControl : this.activeAreasDataControlList) {
            ((Searchable)activeAreaDataControl).recursiveSearch();
        }
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.activeAreasDataControlList);
    }

    public List<ActiveArea> getActiveAreasList() {
        return this.activeAreasList;
    }
}

