/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.scene;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.RectangleArea;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeRectangleValueTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.AddNewPointTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.ChangeRectangularValueTool;
import es.eucm.eadventure.editor.control.tools.general.areaedition.DeletePointTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDetailedDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;

public class ActiveAreaDataControl
extends DataControl
implements RectangleArea {
    private SceneDataControl sceneDataControl;
    private ActiveArea activeArea;
    private ActionsListDataControl actionsListDataControl;
    private ConditionsController conditionsController;
    private InfluenceAreaDataControl influenceAreaDataControl;

    public ActiveAreaDataControl(SceneDataControl sceneDataControl, ActiveArea activeArea) {
        this.sceneDataControl = sceneDataControl;
        this.activeArea = activeArea;
        this.conditionsController = new ConditionsController(new Conditions());
        this.influenceAreaDataControl = new InfluenceAreaDataControl(sceneDataControl, activeArea.getInfluenceArea(), this);
        this.actionsListDataControl = new ActionsListDataControl(activeArea.getActions(), this);
    }

    public ActionsListDataControl getActionsList() {
        return this.actionsListDataControl;
    }

    public String getParentSceneId() {
        return this.sceneDataControl.getId();
    }

    public String getId() {
        return this.activeArea.getId();
    }

    public String getDocumentation() {
        return this.activeArea.getDocumentation();
    }

    public String getName() {
        return this.activeArea.getName();
    }

    public String getBriefDescription() {
        return this.activeArea.getDescription();
    }

    public String getDetailedDescription() {
        return this.activeArea.getDetailedDescription();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.activeArea, string));
    }

    public void setName(String string) {
        this.controller.addTool(new ChangeNameTool((Named)this.activeArea, string));
    }

    public void setBriefDescription(String string) {
        this.controller.addTool(new ChangeDescriptionTool((Described)this.activeArea, string));
    }

    public void setDetailedDescription(String string) {
        this.controller.addTool(new ChangeDetailedDescriptionTool((Detailed)this.activeArea, string));
    }

    public int getX() {
        return this.activeArea.getX();
    }

    public int getY() {
        return this.activeArea.getY();
    }

    public int getWidth() {
        return this.activeArea.getWidth();
    }

    public int getHeight() {
        return this.activeArea.getHeight();
    }

    public void setActiveArea(int n, int n2, int n3, int n4) {
        this.controller.addTool(new ChangeRectangleValueTool((Rectangle)this.activeArea, n, n2, n3, n4));
    }

    @Override
    public Object getContent() {
        return this.activeArea;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.activeArea.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameSceneTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameSceneTitle"), TC.get((String)"Operation.RenameSceneMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.activeArea.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteActiveAreaId(string2);
                this.controller.getIdentifierSummary().addActiveAreaId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        this.actionsListDataControl.updateVarFlagSummary(varFlagSummary);
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.activeArea.getConditions());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        return bl &= this.actionsListDataControl.isValid(string, list);
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        return n += this.actionsListDataControl.countAssetReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.actionsListDataControl.getAssetReferences(list, list2);
    }

    @Override
    public void deleteAssetReferences(String string) {
        this.actionsListDataControl.deleteAssetReferences(string);
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        n += this.actionsListDataControl.countIdentifierReferences(string);
        return n += this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        this.actionsListDataControl.replaceIdentifierReferences(string, string2);
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.actionsListDataControl.deleteIdentifierReferences(string);
        this.conditionsController.deleteIdentifierReferences(string);
    }

    public ConditionsController getConditions() {
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
        ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(2, this.sceneDataControl.getId());
        ConditionsController.ConditionOwner conditionOwner2 = new ConditionsController.ConditionOwner(51, this.activeArea.getId(), conditionOwner);
        hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner2);
        this.conditionsController = new ConditionsController(this.activeArea.getConditions(), hashMap);
        return this.conditionsController;
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.getActionsList().recursiveSearch();
        this.check(this.getBriefDescription(), TC.get((String)"Search.BriefDescription"));
        this.check(this.getConditions(), TC.get((String)"Search.Conditions"));
        this.check(this.getDetailedDescription(), TC.get((String)"Search.DetailedDescription"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        this.check(this.getName(), TC.get((String)"Search.Name"));
    }

    @Override
    public boolean isRectangular() {
        return this.activeArea.isRectangular();
    }

    @Override
    public List<Point> getPoints() {
        return this.activeArea.getPoints();
    }

    @Override
    public void addPoint(int n, int n2) {
        this.controller.addTool(new AddNewPointTool((Rectangle)this.activeArea, n, n2, this.influenceAreaDataControl));
    }

    @Override
    public Point getLastPoint() {
        if (this.activeArea.getPoints().size() > 0) {
            return (Point)this.activeArea.getPoints().get(this.activeArea.getPoints().size() - 1);
        }
        return null;
    }

    @Override
    public void deletePoint(Point point) {
        this.controller.addTool(new DeletePointTool((Rectangle)this.activeArea, point, this.influenceAreaDataControl));
    }

    @Override
    public void setRectangular(boolean bl) {
        this.controller.addTool(new ChangeRectangularValueTool((Rectangle)this.activeArea, bl));
    }

    @Override
    public Rectangle getRectangle() {
        return (Rectangle)this.getContent();
    }

    public InfluenceAreaDataControl getInfluenceArea() {
        return this.influenceAreaDataControl;
    }

    public SceneDataControl getSceneDataControl() {
        return this.sceneDataControl;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.actionsListDataControl);
    }
}

