/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.lomes.time;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.time.LOMESDurationDataControl;

public class LOMESTimeDataControl
extends LOMESDurationDataControl {
    public static final int MILISECONDS = 6;
    public static final int TIMEZONE = 7;
    protected int milisec = 0;
    protected String timeZone = new String();

    @Override
    public String toString() {
        String string = new String();
        if (this.years > 0) {
            string = string + this.years + "-";
        }
        if (this.months > 0 && this.months < 13) {
            string = this.months < 10 ? string + "0" + this.months + "-" : string + this.months + "-";
        }
        if (this.days > 0 && this.days < 32) {
            string = this.days < 10 ? string + "0" + this.days : string + this.days;
        }
        if (this.hours > 0 && this.minutes > 0 && this.seconds > 0) {
            string = string + "T";
            if (this.hours > 0 && this.hours < 24) {
                string = string + this.hours;
            }
            if (this.minutes > 0 && this.minutes < 60) {
                string = string + ":" + this.minutes;
            }
            if (this.seconds > 0 && this.seconds < 60) {
                string = string + ":" + this.seconds;
            }
            if (this.milisec > 0) {
                string = string + "." + this.milisec;
            }
            if (this.timeZone != "") {
                string = string + this.timeZone;
            }
        }
        return string;
    }

    @Override
    public void parseDuration(String string) {
        int n;
        if (string.contains("-")) {
            n = string.indexOf("-");
            this.years = Integer.parseInt(string.substring(0, n));
            string = string.substring(n + 1, string.length());
        }
        if (string.contains("-")) {
            n = string.indexOf("-");
            this.months = Integer.parseInt(string.substring(0, n));
            string = string.substring(n + 1, string.length());
        }
        if (string.contains("T")) {
            int n2;
            n = string.indexOf("T");
            this.days = Integer.parseInt(string.substring(0, n));
            if ((string = string.substring(n + 1, string.length())).contains(":")) {
                n2 = string.indexOf(":");
                this.hours = Integer.parseInt(string.substring(0, n2));
                string = string.substring(n2 + 1, string.length());
            }
            if (string.contains(":")) {
                n2 = string.indexOf(":");
                this.minutes = Integer.parseInt(string.substring(0, n2));
                string = string.substring(n2 + 1, string.length());
            }
            if (string.contains(".")) {
                n2 = string.indexOf(".");
                this.seconds = Integer.parseInt(string.substring(0, n2));
                string = string.substring(n2 + 1, string.length());
            } else {
                this.seconds = Integer.parseInt(string);
                string = "";
            }
            n2 = -1;
            if (string.contains("Z")) {
                n2 = string.indexOf("Z");
            }
            if (string.contains("+")) {
                n2 = string.indexOf("+");
            }
            if (string.contains("-")) {
                n2 = string.indexOf("-");
            }
            if (n2 != -1) {
                this.milisec = Integer.parseInt(string.substring(0, n2));
                this.timeZone = string = string.substring(n2, string.length());
            } else if (!string.equals("")) {
                this.milisec = Integer.parseInt(string);
            }
        } else {
            this.days = Integer.parseInt(string);
            string = "";
        }
    }

    @Override
    protected String paramToString(int n) {
        String string = super.paramToString(n);
        if (string == null) {
            switch (n) {
                case 6: {
                    string = TC.get((String)"LOMES.Date.Miliseconds");
                    break;
                }
                case 7: {
                    string = TC.get((String)"LOMES.Date.TimeZone");
                }
            }
        }
        return string;
    }

    @Override
    protected boolean setParameter(int n, String string) {
        super.setParameter(n, string);
        boolean bl = false;
        try {
            int n2 = -1;
            if (n != 7) {
                if (string == null || string.equals("") || Integer.parseInt(string) > 0) {
                    n2 = string == null || string.equals("") ? 0 : Integer.parseInt(string);
                    this.milisec = n2;
                    bl = true;
                }
            } else {
                this.timeZone = string;
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            Controller.getInstance().showErrorDialog(TC.get((String)"LOM.Duration.InvalidValue.Title"), TC.get((String)"LOM.Duration.InvalidValue.Message", (String)this.paramToString(n)));
        }
        return bl;
    }

    public boolean setMiliSeconds(String string) {
        return this.setParameter(6, string);
    }

    public boolean setTimeZone(String string) {
        return this.setParameter(7, string);
    }

    public String getMilisec() {
        if (this.milisec > 0) {
            return Integer.toString(this.milisec);
        }
        return "";
    }

    public String getTimeZone() {
        return this.timeZone;
    }
}

