/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.lomes;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.LOMESOptionsDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.LOMESTextDataControl;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMIdentifier;
import es.eucm.eadventure.editor.data.meta.lomes.LOMESGeneral;
import java.util.ArrayList;

public class LOMESGeneralDataControl {
    public static final String[] AVAILABLE_LANGS = new String[]{"en", "es"};
    private LOMESGeneral data;

    public LOMESGeneralDataControl(LOMESGeneral lOMESGeneral) {
        this.data = lOMESGeneral;
    }

    public LOMIdentifier getIdentifier() {
        return this.data.getIdentifier();
    }

    public LOMESOptionsDataControl getAggregationLevel() {
        return new LOMESOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMESGeneralDataControl.this.data.getAggregationLevel().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = Integer.toString(i);
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMESGeneralDataControl.this.data.getAggregationLevel().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return LOMESGeneralDataControl.this.data.getAggregationLevel().getValueIndex();
            }
        };
    }

    public LOMESTextDataControl getTitleController() {
        return new LOMESTextDataControl(){

            @Override
            public String getText() {
                return LOMESGeneralDataControl.this.data.getTitle().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMESGeneralDataControl.this.data.setTitle(new LangString(string));
            }
        };
    }

    public LOMESOptionsDataControl getLanguageController() {
        return new LOMESOptionsDataControl(){

            @Override
            public String[] getOptions() {
                return new String[]{TC.get((String)"LOM.General.Language.English"), TC.get((String)"LOM.General.Language.Spanish")};
            }

            @Override
            public void setOption(int n) {
                if (n != this.getSelectedOption()) {
                    LOMESGeneralDataControl.this.data.setLanguage(AVAILABLE_LANGS[n]);
                }
            }

            @Override
            public int getSelectedOption() {
                for (int i = 0; i < AVAILABLE_LANGS.length; ++i) {
                    if (!AVAILABLE_LANGS[i].equals(LOMESGeneralDataControl.this.data.getLanguage())) continue;
                    return i;
                }
                return -1;
            }
        };
    }

    public String[] getKeywordsToString() {
        return this.data.keywordsToString();
    }

    public ArrayList<LangString> getKeywords() {
        return this.data.getKeywords();
    }

    public ArrayList<LangString> getDescriptions() {
        return this.data.getDescriptions();
    }

    public ArrayList<String> getLanguages() {
        return this.data.getLanguages();
    }

    public LOMESGeneral getData() {
        return this.data;
    }

    public void setData(LOMESGeneral lOMESGeneral) {
        this.data = lOMESGeneral;
    }
}

