/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.lom;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.LOMConfigData;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMOptionsDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMTextDataControl;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.lom.LOMGeneral;

public class LOMGeneralDataControl {
    public static final String[] AVAILABLE_LANGS = new String[]{"en", "es"};
    public static final String GROUP = "general";
    private LOMGeneral data;

    public LOMGeneralDataControl(LOMGeneral lOMGeneral) {
        this.data = lOMGeneral;
    }

    public LOMTextDataControl getTitleController() {
        return new LOMTextDataControl(){

            @Override
            public String getText() {
                return LOMGeneralDataControl.this.data.getTitle().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMGeneralDataControl.this.data.setTitle(new LangString(string));
                LOMConfigData.storeData(LOMGeneralDataControl.GROUP, "title", string);
            }
        };
    }

    public LOMOptionsDataControl getLanguageController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                return new String[]{TC.get((String)"LOM.General.Language.English"), TC.get((String)"LOM.General.Language.Spanish")};
            }

            @Override
            public void setOption(int n) {
                if (n != this.getSelectedOption()) {
                    LOMGeneralDataControl.this.data.setLanguage(AVAILABLE_LANGS[n]);
                    Controller.getInstance().updateLOMLanguage();
                    LOMConfigData.storeData(LOMGeneralDataControl.GROUP, "language", Integer.toString(n));
                }
            }

            @Override
            public int getSelectedOption() {
                for (int i = 0; i < AVAILABLE_LANGS.length; ++i) {
                    if (!AVAILABLE_LANGS[i].equals(LOMGeneralDataControl.this.data.getLanguage())) continue;
                    return i;
                }
                return -1;
            }
        };
    }

    public LOMTextDataControl getDescriptionController() {
        return new LOMTextDataControl(){

            @Override
            public String getText() {
                return LOMGeneralDataControl.this.data.getDescription().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMGeneralDataControl.this.data.setDescription(new LangString(string));
                LOMConfigData.storeData(LOMGeneralDataControl.GROUP, "description", string);
            }
        };
    }

    public LOMTextDataControl getKeywordController() {
        return new LOMTextDataControl(){

            @Override
            public String getText() {
                return LOMGeneralDataControl.this.data.getKeyword().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMGeneralDataControl.this.data.setKeyword(new LangString(string));
                LOMConfigData.storeData(LOMGeneralDataControl.GROUP, "keyword", string);
            }
        };
    }

    public LOMGeneral getData() {
        return this.data;
    }

    public void setData(LOMGeneral lOMGeneral) {
        this.data = lOMGeneral;
    }
}

