/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.lom;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.LOMConfigData;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMOptionsDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMTextDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMTypicalLearningTimeDataControl;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.lom.LOMEducational;

public class LOMEducationalDataControl {
    public static final String[] AVAILABLE_LANGS = new String[]{"en", "es"};
    public static final String GROUP = "educational";
    private LOMEducational data;

    public LOMEducationalDataControl(LOMEducational lOMEducational) {
        this.data = lOMEducational;
    }

    public LOMOptionsDataControl getInteractivityTypeController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getInteractivityType().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.InteractivityType" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getInteractivityType().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "interactivityType", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getInteractivityType().getValueIndex();
            }
        };
    }

    public LOMOptionsDataControl getLearningResourceTypeController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[5];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.LearningResourceType" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getLearningResourceType().setValueIndex(this.mapIndex(n));
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "learningResourceType", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return this.mapIndexInverse(LOMEducationalDataControl.this.data.getLearningResourceType().getValueIndex());
            }

            private int mapIndex(int n) {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 13;
                    }
                    case 4: {
                        return 14;
                    }
                }
                return 0;
            }

            private int mapIndexInverse(int n) {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 10: {
                        return 2;
                    }
                    case 13: {
                        return 3;
                    }
                    case 14: {
                        return 4;
                    }
                }
                return 0;
            }
        };
    }

    public LOMOptionsDataControl getInteractivityLevelController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getInteractivityLevel().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.InteractivityLevel" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getInteractivityLevel().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "interactivityLevel", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getInteractivityLevel().getValueIndex();
            }
        };
    }

    public LOMOptionsDataControl getSemanticDensityController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getSemanticDensity().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.SemanticDensity" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getSemanticDensity().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "semanticDensity", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getSemanticDensity().getValueIndex();
            }
        };
    }

    public LOMOptionsDataControl getIntendedEndUserRoleController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getIntendedEndUserRole().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.IntendedEndUserRole" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getIntendedEndUserRole().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "intendedEndUserRole", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getIntendedEndUserRole().getValueIndex();
            }
        };
    }

    public LOMOptionsDataControl getContextController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getContext().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.Context" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getContext().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "context", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getContext().getValueIndex();
            }
        };
    }

    public LOMOptionsDataControl getDifficultyController() {
        return new LOMOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[LOMEducationalDataControl.this.data.getDifficulty().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("LOM.Educational.Difficulty" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                LOMEducationalDataControl.this.data.getDifficulty().setValueIndex(n);
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "difficulty", Integer.toString(n));
            }

            @Override
            public int getSelectedOption() {
                return LOMEducationalDataControl.this.data.getDifficulty().getValueIndex();
            }
        };
    }

    public LOMTextDataControl getDescriptionController() {
        return new LOMTextDataControl(){

            @Override
            public String getText() {
                return LOMEducationalDataControl.this.data.getDescription().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMEducationalDataControl.this.data.setDescription(new LangString(string));
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "description", string);
            }
        };
    }

    public LOMTextDataControl getTypicalAgeRangeController() {
        return new LOMTextDataControl(){

            @Override
            public String getText() {
                return LOMEducationalDataControl.this.data.getTypicalAgeRange().getValue(0);
            }

            @Override
            public void setText(String string) {
                LOMEducationalDataControl.this.data.setTypicalAgeRange(new LangString(string));
                LOMConfigData.storeData(LOMEducationalDataControl.GROUP, "typicalAgeRange", string);
            }
        };
    }

    public LOMTypicalLearningTimeDataControl getTypicalLearningTime() {
        return new LOMTypicalLearningTimeDataControl(this.data);
    }

    public LOMEducational getData() {
        return this.data;
    }

    public void setData(LOMEducational lOMEducational) {
        this.data = lOMEducational;
    }
}

