/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.ims;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSOptionsDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSTextDataControl;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.ims.IMSGeneral;

public class IMSGeneralDataControl {
    public static final String[] AVAILABLE_LANGS = new String[]{"en", "es"};
    private IMSGeneral data;

    public IMSGeneralDataControl(IMSGeneral iMSGeneral) {
        this.data = iMSGeneral;
    }

    public IMSTextDataControl getTitleController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSGeneralDataControl.this.data.getTitle().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSGeneralDataControl.this.data.setTitle(new LangString(string));
            }
        };
    }

    public IMSOptionsDataControl getLanguageController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                return new String[]{TC.get((String)"LOM.General.Language.English"), TC.get((String)"LOM.General.Language.Spanish")};
            }

            @Override
            public void setOption(int n) {
                if (n != this.getSelectedOption()) {
                    IMSGeneralDataControl.this.data.setLanguage(AVAILABLE_LANGS[n]);
                }
            }

            @Override
            public int getSelectedOption() {
                for (int i = 0; i < AVAILABLE_LANGS.length; ++i) {
                    if (!AVAILABLE_LANGS[i].equals(IMSGeneralDataControl.this.data.getLanguage())) continue;
                    return i;
                }
                return -1;
            }
        };
    }

    public IMSTextDataControl getCatalogController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSGeneralDataControl.this.data.getCatalog();
            }

            @Override
            public void setText(String string) {
                IMSGeneralDataControl.this.data.setCalaog(string);
            }
        };
    }

    public IMSTextDataControl getEntryController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSGeneralDataControl.this.data.getEntry().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSGeneralDataControl.this.data.setEntry(new LangString(string));
            }
        };
    }

    public IMSTextDataControl getDescriptionController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSGeneralDataControl.this.data.getDescription().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSGeneralDataControl.this.data.setDescription(new LangString(string));
            }
        };
    }

    public IMSTextDataControl getKeywordController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSGeneralDataControl.this.data.getKeyword().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSGeneralDataControl.this.data.setKeyword(new LangString(string));
            }
        };
    }

    public IMSGeneral getData() {
        return this.data;
    }

    public void setData(IMSGeneral iMSGeneral) {
        this.data = iMSGeneral;
    }
}

