/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.metadata.ims;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSOptionsDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSTextDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSTypicalLearningTimeDataControl;
import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.ims.IMSEducational;

public class IMSEducationalDataControl {
    public static final String[] AVAILABLE_LANGS = new String[]{"en", "es"};
    private IMSEducational data;

    public IMSEducationalDataControl(IMSEducational iMSEducational) {
        this.data = iMSEducational;
    }

    public IMSOptionsDataControl getInteractivityTypeController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getInteractivityType().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.InteractivityType" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getInteractivityType().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getInteractivityType().getValueIndex();
            }
        };
    }

    public IMSOptionsDataControl getLearningResourceTypeController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[14];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.LearningResourceType" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getLearningResourceType().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getLearningResourceType().getValueIndex();
            }

            private int mapIndex(int n) {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 10;
                    }
                    case 3: {
                        return 13;
                    }
                    case 4: {
                        return 14;
                    }
                }
                return 0;
            }

            private int mapIndexInverse(int n) {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 10: {
                        return 2;
                    }
                    case 13: {
                        return 3;
                    }
                    case 14: {
                        return 4;
                    }
                }
                return 0;
            }
        };
    }

    public IMSOptionsDataControl getInteractivityLevelController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getInteractivityLevel().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.InteractivityLevel" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getInteractivityLevel().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getInteractivityLevel().getValueIndex();
            }
        };
    }

    public IMSOptionsDataControl getSemanticDensityController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getSemanticDensity().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.SemanticDensity" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getSemanticDensity().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getSemanticDensity().getValueIndex();
            }
        };
    }

    public IMSOptionsDataControl getIntendedEndUserRoleController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getIntendedEndUserRole().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.IntendedEndUserRole" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getIntendedEndUserRole().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getIntendedEndUserRole().getValueIndex();
            }
        };
    }

    public IMSOptionsDataControl getContextController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getContext().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.Contex" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getContext().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getContext().getValueIndex();
            }
        };
    }

    public IMSOptionsDataControl getDifficultyController() {
        return new IMSOptionsDataControl(){

            @Override
            public String[] getOptions() {
                String[] stringArray = new String[IMSEducationalDataControl.this.data.getDifficulty().getValues().length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TC.get((String)("IMS.Educational.Difficulty" + i));
                }
                return stringArray;
            }

            @Override
            public void setOption(int n) {
                IMSEducationalDataControl.this.data.getDifficulty().setValueIndex(n);
            }

            @Override
            public int getSelectedOption() {
                return IMSEducationalDataControl.this.data.getDifficulty().getValueIndex();
            }
        };
    }

    public IMSTextDataControl getDescriptionController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSEducationalDataControl.this.data.getDescription().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSEducationalDataControl.this.data.setDescription(new LangString(string));
            }
        };
    }

    public IMSTextDataControl getTypicalAgeRangeController() {
        return new IMSTextDataControl(){

            @Override
            public String getText() {
                return IMSEducationalDataControl.this.data.getTypicalAgeRange().getValue(0);
            }

            @Override
            public void setText(String string) {
                IMSEducationalDataControl.this.data.setTypicalAgeRange(new LangString(string));
            }
        };
    }

    public IMSTypicalLearningTimeDataControl getTypicalLearningTime() {
        return new IMSTypicalLearningTimeDataControl(this.data);
    }

    public IMSEducational getData() {
        return this.data;
    }

    public void setData(IMSEducational iMSEducational) {
        this.data = iMSEducational;
    }
}

