/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.macro;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.macro.MacroDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class MacroListDataControl
extends DataControl {
    private List<Macro> macrosList;
    private List<MacroDataControl> macrosDataControlList;

    public MacroListDataControl(List<Macro> list) {
        this.macrosList = list;
        this.macrosDataControlList = new ArrayList<MacroDataControl>();
        for (Macro macro : list) {
            this.macrosDataControlList.add(new MacroDataControl(macro));
        }
    }

    public List<MacroDataControl> getMacros() {
        return this.macrosDataControlList;
    }

    public MacroDataControl getLastMacro() {
        return this.macrosDataControlList.get(this.macrosDataControlList.size() - 1);
    }

    public String[][] getMacrosInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.macrosList.size()][2];
        for (int i = 0; i < this.macrosList.size(); ++i) {
            Macro macro = this.macrosList.get(i);
            stringArray[i][0] = macro.getId();
            stringArray[i][1] = Integer.toString(Controller.getInstance().countIdentifierReferences(macro.getId()));
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.macrosList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{56};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 56;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 56) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddMacroTitle"), TC.get((String)"Operation.AddMacroMessage"), TC.get((String)"Operation.AddMacroDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Macro macro = new Macro(string);
                this.macrosList.add(macro);
                this.macrosDataControlList.add(new MacroDataControl(macro));
                this.controller.getIdentifierSummary().addMacroId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof MacroDataControl)) {
            return false;
        }
        try {
            Macro macro = (Macro)((Macro)dataControl.getContent()).clone();
            String string = macro.getId();
            int n = 1;
            do {
                string = macro.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            macro.setId(string);
            this.macrosList.add(macro);
            this.macrosDataControlList.add(new MacroDataControl(macro));
            this.controller.getIdentifierSummary().addMacroId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone macro");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddMacroDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((MacroDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.macrosList.remove(dataControl.getContent())) {
            this.macrosDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteMacroId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.macrosList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.macrosList.add(n - 1, this.macrosList.remove(n));
            this.macrosDataControlList.add(n - 1, this.macrosDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.macrosList.indexOf(dataControl.getContent());
        if (n < this.macrosList.size() - 1) {
            this.macrosList.add(n + 1, this.macrosList.remove(n));
            this.macrosDataControlList.add(n + 1, this.macrosDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            macroDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)55);
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            String string2 = string + " >> " + macroDataControl.getId();
            bl &= macroDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            n += macroDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            macroDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            macroDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            n += macroDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            macroDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            macroDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (MacroDataControl macroDataControl : this.macrosDataControlList) {
            ((Searchable)macroDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.macrosDataControlList);
    }

    public List<Macro> getMacrosList() {
        return this.macrosList;
    }
}

