/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.macro;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.List;

public class MacroDataControl
extends DataControl {
    private EffectsController controller;
    private Macro macro;

    public MacroDataControl(Macro macro) {
        this.macro = macro;
        this.controller = new EffectsController((Effects)this.macro);
    }

    public void setDocumentation(String string) {
        Controller.getInstance().addTool(new ChangeDocumentationTool((Documented)this.macro, string));
    }

    public String getDocumentation() {
        return this.macro.getDocumentation();
    }

    public String getId() {
        return this.macro.getId();
    }

    public EffectsController getController() {
        return this.controller;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        int n = Controller.getInstance().countIdentifierReferences(this.getId());
        return n == 0;
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return EffectsController.countAssetReferences(string, (Effects)this.macro);
    }

    @Override
    public int countIdentifierReferences(String string) {
        return EffectsController.countIdentifierReferences(string, (Effects)this.macro);
    }

    @Override
    public void deleteAssetReferences(String string) {
        EffectsController.deleteAssetReferences(string, (Effects)this.macro);
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        EffectsController.deleteIdentifierReferences(string, (Effects)this.macro);
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        EffectsController.getAssetReferences(list, list2, (Effects)this.macro);
    }

    @Override
    public Object getContent() {
        return this.macro;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return EffectsController.isValid(string, list, (Effects)this.macro);
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.getId();
        String string3 = String.valueOf(Controller.getInstance().countIdentifierReferences(string2));
        if (string != null || Controller.getInstance().showStrictConfirmDialog(TC.get((String)"Operation.RenameMacroTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = Controller.getInstance().showInputDialog(TC.get((String)"Operation.RenameMacroTitle"), TC.get((String)"Operation.RenameMacroMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && Controller.getInstance().isElementIdValid(string4)) {
                this.macro.setId(string4);
                Controller.getInstance().replaceIdentifierReferences(string2, string4);
                Controller.getInstance().getIdentifierSummary().deleteMacroId(string2);
                Controller.getInstance().getIdentifierSummary().addMacroId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        EffectsController.replaceIdentifierReferences(string, string2, (Effects)this.macro);
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        EffectsController.updateVarFlagSummary(varFlagSummary, (Effects)this.macro);
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        for (int i = 0; i < this.getController().getEffectCount(); ++i) {
            this.check(this.getController().getEffectInfo(i), TC.get((String)"Search.Effect"));
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

