/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.item;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ItemsListDataControl
extends DataControl {
    private List<Item> itemsList;
    private List<ItemDataControl> itemsDataControlList;

    public ItemsListDataControl(List<Item> list) {
        this.itemsList = list;
        this.itemsDataControlList = new ArrayList<ItemDataControl>();
        for (Item item : list) {
            this.itemsDataControlList.add(new ItemDataControl(item));
        }
    }

    public List<ItemDataControl> getItems() {
        return this.itemsDataControlList;
    }

    public ItemDataControl getLastItem() {
        return this.itemsDataControlList.get(this.itemsDataControlList.size() - 1);
    }

    public String[][] getItemsInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.itemsList.size()][2];
        for (int i = 0; i < this.itemsList.size(); ++i) {
            Item item = this.itemsList.get(i);
            stringArray[i][0] = item.getId();
            stringArray[i][1] = TC.get((String)"ItemsList.ActionsNumber", (String)String.valueOf(item.getActions().size()));
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.itemsList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{19};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 19;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 19) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddItemTitle"), TC.get((String)"Operation.AddItemMessage"), TC.get((String)"Operation.AddItemDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Item item = new Item(string);
                this.itemsList.add(item);
                this.itemsDataControlList.add(new ItemDataControl(item));
                this.controller.getIdentifierSummary().addItemId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof ItemDataControl)) {
            return false;
        }
        try {
            Item item = (Item)((Item)dataControl.getContent()).clone();
            String string = item.getId();
            int n = 1;
            do {
                string = item.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            item.setId(string);
            this.itemsList.add(item);
            this.itemsDataControlList.add(new ItemDataControl(item));
            this.controller.getIdentifierSummary().addItemId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone item");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddItemDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((ItemDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.itemsList.remove(dataControl.getContent())) {
            this.itemsDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteItemId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.itemsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.itemsList.add(n - 1, this.itemsList.remove(n));
            this.itemsDataControlList.add(n - 1, this.itemsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.itemsList.indexOf(dataControl.getContent());
        if (n < this.itemsList.size() - 1) {
            this.itemsList.add(n + 1, this.itemsList.remove(n));
            this.itemsDataControlList.add(n + 1, this.itemsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            itemDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)18);
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            String string2 = string + " >> " + itemDataControl.getId();
            bl &= itemDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            n += itemDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            itemDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            itemDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            n += itemDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            itemDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            itemDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (ItemDataControl itemDataControl : this.itemsDataControlList) {
            ((Searchable)itemDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.itemsDataControlList);
    }
}

