/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.imageedition.filter;

import es.eucm.eadventure.editor.control.controllers.imageedition.filter.ImageFilter;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Stack;

public class TransparentColorFilter
implements ImageFilter {
    private int threshold = 15;
    private boolean contiguous = true;
    private int alphaValue = 0;
    private boolean active = false;
    private int width;
    private int height;
    private int[] imagePixels;
    private int rT;
    private int gT;
    private int bT;
    private int aT;
    private boolean[] pixelsDone;
    private Stack<Point> stack;

    public TransparentColorFilter(boolean bl, int n) {
        this.contiguous = bl;
        this.threshold = n;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public void transform(BufferedImage bufferedImage, int n, int n2) {
        if (this.active && bufferedImage.getColorModel().getNumComponents() == 4) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            writableRaster.getPixel(n, n2, nArray);
            int[] nArray2 = new int[bufferedImage.getWidth() * bufferedImage.getHeight() * 4];
            writableRaster.getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray2);
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2];
            int n6 = nArray[3];
            if (this.contiguous) {
                this.initAlgorithm(bufferedImage, nArray2, n3, n4, n5, n6);
                this.applyAlgorithm(n, n2);
            } else {
                for (int i = 0; i < nArray2.length; i += 4) {
                    int n7 = nArray2[i];
                    int n8 = nArray2[i + 1];
                    int n9 = nArray2[i + 2];
                    if (n7 < n3 - this.threshold || n7 > n3 + this.threshold || n8 < n4 - this.threshold || n8 > n4 + this.threshold || n9 < n5 - this.threshold || n9 > n5 + this.threshold) continue;
                    nArray2[i + 3] = this.alphaValue;
                }
            }
            writableRaster.setPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray2);
        }
    }

    private void initAlgorithm(BufferedImage bufferedImage, int[] nArray, int n, int n2, int n3, int n4) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.imagePixels = nArray;
        this.rT = n;
        this.gT = n2;
        this.bT = n3;
        this.aT = n4;
        this.pixelsDone = new boolean[this.width * this.height];
        this.stack = new Stack();
        for (int i = 0; i < this.pixelsDone.length; ++i) {
            int n5 = i * 4;
            this.pixelsDone[i] = nArray[n5] >= n + this.threshold || nArray[n5] <= n - this.threshold || nArray[n5 + 1] >= n2 + this.threshold || nArray[n5 + 1] <= n2 - this.threshold || nArray[n5 + 2] >= n3 + this.threshold || nArray[n5 + 2] <= n3 - this.threshold || nArray[n5 + 3] >= n4 + this.threshold || nArray[n5 + 3] <= n4 - this.threshold;
        }
    }

    private void applyAlgorithm(int n, int n2) {
        this.stack.push(new Point(n, n2));
        while (!this.stack.isEmpty()) {
            int n3;
            Point point = this.stack.pop();
            int n4 = point.x;
            int n5 = point.y;
            if (n4 < 0 || n4 >= this.width || n5 < 0 || n5 >= this.height || (n3 = n5 * this.width + n4) < 0 || n3 >= this.pixelsDone.length || this.pixelsDone[n3]) continue;
            this.pixelsDone[n3] = true;
            int n6 = n3 * 4;
            if (this.imagePixels[n6] >= this.rT + this.threshold || this.imagePixels[n6] <= this.rT - this.threshold || this.imagePixels[n6 + 1] >= this.gT + this.threshold || this.imagePixels[n6 + 1] <= this.gT - this.threshold || this.imagePixels[n6 + 2] >= this.bT + this.threshold || this.imagePixels[n6 + 2] <= this.bT - this.threshold || this.imagePixels[n6 + 3] >= this.aT + this.threshold || this.imagePixels[n6 + 3] <= this.aT - this.threshold) continue;
            this.imagePixels[n6 + 3] = this.alphaValue;
            if (n4 - 1 >= 0 && !this.pixelsDone[n3 - 1]) {
                this.stack.push(new Point(n4 - 1, n5));
            }
            if (n4 + 1 < this.width && !this.pixelsDone[n3 + 1]) {
                this.stack.push(new Point(n4 + 1, n5));
            }
            if (n5 - 1 >= 0 && !this.pixelsDone[n3 - this.width]) {
                this.stack.push(new Point(n4, n5 - 1));
            }
            if (n5 + 1 >= this.height || this.pixelsDone[n3 + this.width]) continue;
            this.stack.push(new Point(n4, n5 + 1));
        }
    }

    public void setThreshold(int n) {
        if (n >= 1 && n <= 255) {
            this.threshold = n;
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setContiguous(boolean bl) {
        this.contiguous = bl;
    }

    public boolean isContiguous() {
        return this.contiguous;
    }

    public void setAlphaValue(int n) {
        this.alphaValue = n;
    }
}

