/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.imageedition;

import es.eucm.eadventure.editor.gui.displaydialogs.SelectImageDialog;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementSelectImage;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class SelectImageController
extends MouseInputAdapter {
    private ImageElementSelectImage underMouse;
    protected int startDragX;
    protected int startDragY;
    protected int originalX;
    protected int originalY;
    protected int originalWidth;
    protected int originalHeight;
    protected float originalScale;
    private SelectImageDialog selectImageDialog;

    public SelectImageController(ImageElementSelectImage imageElementSelectImage, SelectImageDialog selectImageDialog) {
        this.selectImageDialog = selectImageDialog;
        this.underMouse = imageElementSelectImage;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.underMouse.isMovable() || this.underMouse.isResize() || this.underMouse.isResizeWidth()) {
            this.startDragX = this.underMouse.getRealSize(mouseEvent.getX());
            this.startDragY = this.underMouse.getRealSize(mouseEvent.getY());
            this.originalX = this.underMouse.getX();
            this.originalY = this.underMouse.getY();
            this.originalWidth = this.underMouse.getWidth();
            this.originalHeight = this.underMouse.getHeight();
            this.originalScale = this.underMouse.getScale();
        }
        this.underMouse.recreateImage();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        this.underMouse.recreateImage();
        this.selectImageDialog.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.underMouse.isMovable() && !this.underMouse.isResizeWidth() && !this.underMouse.isResize()) {
            int n = this.underMouse.getRealSize(mouseEvent.getX()) - this.startDragX;
            int n2 = this.underMouse.getRealSize(mouseEvent.getY()) - this.startDragY;
            int n3 = this.originalX + n;
            int n4 = this.originalY + n2;
            this.underMouse.changePosition(n3, n4);
            this.selectImageDialog.repaint();
        } else if (!this.underMouse.isResize() && this.underMouse.isResizeWidth()) {
            int n = this.underMouse.getRealSize(mouseEvent.getX()) - this.startDragX;
            this.underMouse.changeWidth(this.originalWidth + n);
            this.selectImageDialog.repaint();
        } else if (this.underMouse.isResize() && !this.underMouse.isResizeWidth()) {
            int n = this.underMouse.getRealSize(mouseEvent.getX()) - this.startDragX;
            int n5 = this.underMouse.getRealSize(mouseEvent.getY()) - this.startDragY;
            this.underMouse.changeSize(this.originalWidth + n, this.originalHeight + n5);
            this.selectImageDialog.repaint();
        }
    }

    protected void setMouseUnder(int n, int n2) {
        int n3 = this.underMouse.getRealX(n);
        int n4 = this.underMouse.getRealY(n2);
        this.underMouse.getMovableElement(n3, n4);
        this.underMouse.getResizeElement(n3, n4);
        if (this.underMouse.isResize()) {
            this.selectImageDialog.setCursor(Cursor.getPredefinedCursor(5));
        } else if (this.underMouse.isResizeWidth()) {
            this.selectImageDialog.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.underMouse.isMovable()) {
            this.selectImageDialog.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.selectImageDialog.setCursor(Cursor.getDefaultCursor());
        }
    }
}

