/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.imageedition;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.imageedition.EditImageController;
import es.eucm.eadventure.editor.control.controllers.imageedition.filter.TransparentColorFilter;
import es.eucm.eadventure.editor.gui.displaydialogs.GraphicDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageToolBar
extends JPanel {
    private static final long serialVersionUID = -87717263659816496L;
    private TransparentColorFilter filter;
    private EditImageController controller;
    private ArrayList<JComponent> tools;
    private GraphicDialog.ImagePanel panel;

    public ImageToolBar(boolean bl, TransparentColorFilter transparentColorFilter, EditImageController editImageController, GraphicDialog.ImagePanel imagePanel) {
        this.panel = imagePanel;
        this.filter = transparentColorFilter;
        this.controller = editImageController;
        this.setLayout(new GridBagLayout());
        this.tools = new ArrayList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JToggleButton jToggleButton = new JToggleButton(TC.get((String)"ImageEdition.SelectColorTransparent"));
        jToggleButton.setEnabled(bl);
        this.add((Component)jToggleButton, gridBagConstraints);
        if (bl) {
            jToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JToggleButton)actionEvent.getSource()).isSelected();
                    ImageToolBar.this.filter.setActive(bl);
                    for (JComponent jComponent : ImageToolBar.this.tools) {
                        jComponent.setEnabled(bl);
                    }
                    if (bl) {
                        ImageToolBar.this.panel.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        ImageToolBar.this.panel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
            ++gridBagConstraints.gridx;
            this.add((Component)new JSeparator(1), gridBagConstraints);
            JButton jButton = new JButton(new ImageIcon("img/icons/undo.png"));
            jButton.setToolTipText(TC.get((String)"Tools.Undo"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImageToolBar.this.controller.undo();
                }
            });
            this.tools.add(jButton);
            ++gridBagConstraints.gridx;
            this.add((Component)jButton, gridBagConstraints);
            JButton jButton2 = new JButton(new ImageIcon("img/icons/redo.png"));
            jButton2.setToolTipText(TC.get((String)"Tools.Redo"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImageToolBar.this.controller.redo();
                }
            });
            ++gridBagConstraints.gridx;
            this.add((Component)jButton2, gridBagConstraints);
            this.tools.add(jButton2);
            ++gridBagConstraints.gridx;
            this.add((Component)new JSeparator(1), gridBagConstraints);
            JCheckBox jCheckBox = new JCheckBox(TC.get((String)"ImageEdition.Contiguous"));
            jCheckBox.setSelected(transparentColorFilter.isContiguous());
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImageToolBar.this.filter.setContiguous(!ImageToolBar.this.filter.isContiguous());
                }
            });
            ++gridBagConstraints.gridx;
            this.add((Component)jCheckBox, gridBagConstraints);
            this.tools.add(jCheckBox);
            ++gridBagConstraints.gridx;
            this.add((Component)new JSeparator(1), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(TC.get((String)"ImageEdition.Threshold")), gridBagConstraints);
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(transparentColorFilter.getThreshold(), 10, 255, 1));
            jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ImageToolBar.this.filter.setThreshold((Integer)((JSpinner)changeEvent.getSource()).getValue());
                }
            });
            ++gridBagConstraints.gridx;
            this.add((Component)jSpinner, gridBagConstraints);
            this.tools.add(jSpinner);
            jToggleButton.setSelected(false);
            for (JComponent jComponent : this.tools) {
                jComponent.setEnabled(false);
            }
        } else {
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(TC.get((String)"ImageEdition.NoTransparencyAllowed")), gridBagConstraints);
        }
    }
}

