/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.imageedition;

import es.eucm.eadventure.editor.control.controllers.imageedition.filter.TransparentColorFilter;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.JDialog;

public class EditImageController {
    private BufferedImage image;
    private TransparentColorFilter filter;
    private JDialog frame;
    private Stack<Operation> undoOperations;
    private Stack<Operation> redoOperations;
    private int changed;

    public EditImageController(BufferedImage bufferedImage, JDialog jDialog) {
        this.image = bufferedImage;
        this.frame = jDialog;
        this.undoOperations = new Stack();
        this.redoOperations = new Stack();
        this.changed = 0;
    }

    public void transform(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.image.getWidth() && n2 < this.image.getHeight()) {
            this.filter.setAlphaValue(0);
            this.filter.transform(this.image, n, n2);
            ++this.changed;
            this.redoOperations.clear();
            if (this.undoOperations.size() == 10) {
                this.undoOperations.remove(this.undoOperations.size() - 1);
            }
            this.undoOperations.push(new Operation(n, n2, this.filter.getThreshold(), this.filter.isContiguous()));
            this.frame.repaint();
        }
    }

    public void undo() {
        if (!this.undoOperations.isEmpty()) {
            Operation operation = this.undoOperations.pop();
            this.redoOperations.push(operation);
            this.applyFilter(operation, 255);
            --this.changed;
        }
    }

    public void redo() {
        if (!this.redoOperations.isEmpty()) {
            Operation operation = this.redoOperations.pop();
            this.undoOperations.push(operation);
            this.applyFilter(operation, 0);
            ++this.changed;
        }
    }

    private void applyFilter(Operation operation, int n) {
        int n2 = this.filter.getThreshold();
        boolean bl = this.filter.isContiguous();
        this.filter.setThreshold(operation.threshold);
        this.filter.setContiguous(operation.contiguous);
        this.filter.setAlphaValue(n);
        this.filter.transform(this.image, operation.x, operation.y);
        this.filter.setThreshold(n2);
        this.filter.setContiguous(bl);
        this.frame.repaint();
    }

    public void setImageFilter(TransparentColorFilter transparentColorFilter) {
        this.filter = transparentColorFilter;
    }

    public boolean isChanged() {
        return this.changed != 0;
    }

    private class Operation {
        public int x;
        public int y;
        public int threshold;
        public boolean contiguous;

        public Operation(int n, int n2, int n3, boolean bl) {
            this.x = n;
            this.y = n2;
            this.threshold = n3;
            this.contiguous = bl;
        }
    }
}

