/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.globalstate;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class GlobalStateListDataControl
extends DataControl {
    private List<GlobalState> globalStatesList;
    private List<GlobalStateDataControl> globalStatesDataControlList;

    public GlobalStateListDataControl(List<GlobalState> list) {
        this.globalStatesList = list;
        this.globalStatesDataControlList = new ArrayList<GlobalStateDataControl>();
        for (GlobalState globalState : list) {
            this.globalStatesDataControlList.add(new GlobalStateDataControl(globalState));
        }
    }

    public List<GlobalStateDataControl> getGlobalStates() {
        return this.globalStatesDataControlList;
    }

    public GlobalStateDataControl getLastGlobalState() {
        return this.globalStatesDataControlList.get(this.globalStatesDataControlList.size() - 1);
    }

    public String[][] getGlobalStatesInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.globalStatesList.size()][2];
        for (int i = 0; i < this.globalStatesList.size(); ++i) {
            GlobalState globalState = this.globalStatesList.get(i);
            stringArray[i][0] = globalState.getId();
            stringArray[i][1] = Integer.toString(Controller.getInstance().countIdentifierReferences(globalState.getId()));
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.globalStatesList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{54};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 54;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 54) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddGlobalStateTitle"), TC.get((String)"Operation.AddGlobalStateMessage"), TC.get((String)"Operation.AddGlobalStateDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                GlobalState globalState = new GlobalState(string);
                this.globalStatesList.add(globalState);
                this.globalStatesDataControlList.add(new GlobalStateDataControl(globalState));
                this.controller.getIdentifierSummary().addGlobalStateId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof GlobalStateDataControl)) {
            return false;
        }
        try {
            GlobalState globalState = (GlobalState)((GlobalState)dataControl.getContent()).clone();
            String string = globalState.getId();
            int n = 1;
            do {
                string = globalState.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            globalState.setId(string);
            this.globalStatesList.add(globalState);
            this.globalStatesDataControlList.add(new GlobalStateDataControl(globalState));
            this.controller.getIdentifierSummary().addGlobalStateId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone global state");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddGlobalStateDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((GlobalStateDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.globalStatesList.remove(dataControl.getContent())) {
            this.globalStatesDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteGlobalStateId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.globalStatesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.globalStatesList.add(n - 1, this.globalStatesList.remove(n));
            this.globalStatesDataControlList.add(n - 1, this.globalStatesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.globalStatesList.indexOf(dataControl.getContent());
        if (n < this.globalStatesList.size() - 1) {
            this.globalStatesList.add(n + 1, this.globalStatesList.remove(n));
            this.globalStatesDataControlList.add(n + 1, this.globalStatesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            globalStateDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)55);
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            String string2 = string + " >> " + globalStateDataControl.getId();
            bl &= globalStateDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            n += globalStateDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            globalStateDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            globalStateDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            n += globalStateDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            globalStateDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            globalStateDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (GlobalStateDataControl globalStateDataControl : this.globalStatesDataControlList) {
            ((Searchable)globalStateDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.globalStatesDataControlList);
    }

    public List<GlobalState> getGlobalStatesList() {
        return this.globalStatesList;
    }
}

