/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.globalstate;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.List;

public class GlobalStateDataControl
extends DataControl {
    private ConditionsController controller;
    private GlobalState globalState;

    public GlobalStateDataControl(GlobalState globalState) {
        this.globalState = globalState;
        this.controller = new ConditionsController((Conditions)this.globalState, 54, this.globalState.getId());
    }

    public void setDocumentation(String string) {
        Controller.getInstance().addTool(new ChangeDocumentationTool((Documented)this.globalState, string));
    }

    public String getDocumentation() {
        return this.globalState.getDocumentation();
    }

    public String getId() {
        return this.globalState.getId();
    }

    public ConditionsController getController() {
        return this.controller;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        int n = Controller.getInstance().countIdentifierReferences(this.getId());
        return n == 0;
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        return n += this.controller.countIdentifierReferences(string);
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.controller.deleteIdentifierReferences(string);
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public Object getContent() {
        return this.globalState;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.getId();
        String string3 = String.valueOf(Controller.getInstance().countIdentifierReferences(string2));
        if (string != null || Controller.getInstance().showStrictConfirmDialog(TC.get((String)"Operation.RenameGlobalStateTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = Controller.getInstance().showInputDialog(TC.get((String)"Operation.RenameGlobalStateTitle"), TC.get((String)"Operation.RenameGlobalStateMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && Controller.getInstance().isElementIdValid(string4)) {
                this.globalState.setId(string4);
                Controller.getInstance().replaceIdentifierReferences(string2, string4);
                Controller.getInstance().getIdentifierSummary().deleteGlobalStateId(string2);
                Controller.getInstance().getIdentifierSummary().addGlobalStateId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.globalState.getId().equals(string)) {
            this.globalState.setId(string2);
            Controller.getInstance().getIdentifierSummary().deleteGlobalStateId(string);
            Controller.getInstance().getIdentifierSummary().addGlobalStateId(string2);
        }
        this.controller.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, (Conditions)this.globalState);
    }

    @Override
    public void recursiveSearch() {
        this.check(this.controller, TC.get((String)"Search.Conditions"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

