/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteAssetReferencesInResources;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteResourceTool;
import es.eucm.eadventure.editor.control.tools.general.assets.EditResourceTool;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Image;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcesDataControl
extends DataControl {
    private Resources resources;
    private AssetInformation[] assetsInformation;
    private int[][] assetsGroups = null;
    private String[] groupsInfo = null;
    private ConditionsController conditionsController;
    private int resourcesType;
    private Map<String, String> imageIconMap;

    public ResourcesDataControl(Resources resources, int n) {
        this.resources = resources;
        this.resourcesType = n;
        switch (n) {
            case 2: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionSceneBackground", "background", true, 0, 1), new AssetInformation("Resources.DescriptionSceneForeground", "foreground", false, 0, 2), new AssetInformation("Resources.DescriptionSceneMusic", "bgmusic", false, 4, 0)};
                break;
            }
            case 10: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionSlidesceneSlides", "slides", true, 1, 1), new AssetInformation("Resources.DescriptionSceneMusic", "bgmusic", false, 4, 0)};
                break;
            }
            case 230: 
            case 250: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionButtonNormal", "buttonNormal", true, 9, 2), new AssetInformation("Resources.DescriptionButtonOver", "buttonOver", true, 9, 2), new AssetInformation("Resources.DescriptionActionAnimation", "actionAnimation", false, 1, 0), new AssetInformation("Resources.DescriptionActionAnimationLeft", "actionAnimationLeft", false, 1, 0)};
                this.assetsGroups = new int[][]{{0, 1}, {2, 3}};
                this.groupsInfo = new String[]{"Resources.Button", "Resources.Animations"};
                break;
            }
            case 37: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionVideoscenes", "video", true, 5, 0)};
                break;
            }
            case 12: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionBookBackground", "background", true, 0, 1), new AssetInformation("Resources.ArrowLeftNormal", "arrowLeftNormal", false, 11, 2), new AssetInformation("Resources.ArrowRightNormal", "arrowRightNormal", false, 11, 2), new AssetInformation("Resources.ArrowLeftOver", "arrowLeftOver", false, 11, 2), new AssetInformation("Resources.ArrowRightOver", "arrowRightOver", false, 11, 2)};
                break;
            }
            case 19: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionItemImage", "image", true, 2, 0), new AssetInformation("Resources.DescriptionItemIcon", "icon", false, 3, 0)};
                this.imageIconMap = new HashMap<String, String>();
                this.imageIconMap.put("icon", "image");
                break;
            }
            case 26: 
            case 28: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionCharacterAnimationStandUp", "standup", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationStandDown", "standdown", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationStandRight", "standright", !Controller.getInstance().isPlayTransparent(), 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationStandLeft", "standleft", !Controller.getInstance().isPlayTransparent(), 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationSpeakUp", "speakup", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationSpeakDown", "speakdown", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationSpeakRight", "speakright", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationSpeakLeft", "speakleft", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationUseRight", "useright", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationUseLeft", "useleft", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationWalkUp", "walkup", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationWalkDown", "walkdown", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationWalkRight", "walkright", false, 1, 2), new AssetInformation("Resources.DescriptionCharacterAnimationWalkLeft", "walkleft", false, 1, 2)};
                this.assetsGroups = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9}, {10, 11, 12, 13}};
                this.groupsInfo = new String[]{"Resources.StandingAnimations", "Resources.SpeakingAnimations", "Resources.UsingAnimations", "Resources.WalkingAnimations"};
                break;
            }
            case 58: {
                this.assetsInformation = new AssetInformation[]{new AssetInformation("Resources.DescriptionItemImage", "image", true, 2, 0)};
            }
        }
        this.conditionsController = new ConditionsController(resources.getConditions(), 34, TC.getElement((int)n));
    }

    public int getResourcesType() {
        return this.resourcesType;
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    public int getAssetCount() {
        return this.assetsInformation.length;
    }

    public String getAssetName(int n) {
        return this.assetsInformation[n].name;
    }

    public String getAssetDescription(int n) {
        return TC.get((String)this.assetsInformation[n].description);
    }

    public int getAssetCategory(int n) {
        return this.assetsInformation[n].category;
    }

    public int getAssetFilter(int n) {
        return this.assetsInformation[n].filter;
    }

    public String getAssetPath(String string) {
        return this.resources.getAssetPath(string);
    }

    public String getAssetPath(int n) {
        return this.resources.getAssetPath(this.assetsInformation[n].name);
    }

    public void editAssetPath(int n) {
        try {
            this.controller.addTool(new SelectResourceTool(this.resources, this.assetsInformation, this.resourcesType, n));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public void deleteAssetPath(int n) {
        try {
            this.controller.addTool(new DeleteResourceTool(this.resources, this.assetsInformation, n));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public Object getContent() {
        return this.resources;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        this.resources.setName(string);
        return string;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.resources.getConditions());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (AssetInformation assetInformation : this.assetsInformation) {
            if (!assetInformation.assetNecessary || this.resources.getAssetPath(assetInformation.name) != null) continue;
            bl = false;
            if (list == null) continue;
            list.add(string + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorResources", (String)assetInformation.name));
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (String string2 : this.resources.getAssetTypes()) {
            if (!this.resources.getAssetPath(string2).equals(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (int i = 0; i < this.assetsInformation.length; ++i) {
            if (this.resources.getAssetPath(this.assetsInformation[i].name) == null || this.resources.getAssetPath(this.assetsInformation[i].name).equals("")) continue;
            String string = this.resources.getAssetPath(this.assetsInformation[i].name);
            int n = this.assetsInformation[i].category;
            boolean bl = true;
            for (String string2 : list) {
                if (!string2.equals(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n2 = list.size();
            list.add(n2, string);
            list2.add(n2, n);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        try {
            this.controller.addTool(new DeleteAssetReferencesInResources(this.resources, string));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        return this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        this.conditionsController.deleteIdentifierReferences(string);
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    public void setAssetPath(String string, int n) {
        try {
            this.controller.addTool(new EditResourceTool(this.resources, this.assetsInformation, n, string));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getConditions(), TC.get((String)"Search.Conditions"));
        for (int i = 0; i < this.getAssetCount(); ++i) {
            this.check(this.getAssetDescription(i), TC.get((String)"Search.AssetDescription"));
            this.check(this.getAssetPath(i), TC.get((String)"Search.AssetPath"));
        }
    }

    public int getAssetGroupCount() {
        if (this.assetsGroups == null) {
            return 1;
        }
        return this.assetsGroups.length;
    }

    public String getGroupInfo(int n) {
        return TC.get((String)this.groupsInfo[n]);
    }

    public int getGroupAssetCount(int n) {
        return this.assetsGroups[n].length;
    }

    public int getAssetIndex(int n, int n2) {
        if (this.assetsGroups == null) {
            return n2;
        }
        return this.assetsGroups[n][n2];
    }

    public boolean isIconFromImage(int n) {
        if (this.imageIconMap == null) {
            return false;
        }
        return this.imageIconMap.get(this.assetsInformation[n].name) != null;
    }

    public int getOriginalImage(int n) {
        String string = this.imageIconMap.get(this.assetsInformation[n].name);
        for (int i = 0; i < this.assetsInformation.length; ++i) {
            if (!this.assetsInformation[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }

    public static void framesFromImages(Animation animation, String string) {
        ResourcesDataControl.framesFromImages(animation, string, false);
    }

    public static void framesFromImages(Animation animation, String string, boolean bl) {
        animation.getFrames().clear();
        animation.getTransitions().clear();
        animation.getTransitions().add(new Transition());
        animation.getTransitions().add(new Transition());
        int n = 1;
        Image image = null;
        boolean bl2 = false;
        while (!bl2) {
            String string2 = string + "_" + ResourcesDataControl.leadingZeros(n) + ".jpg";
            image = AssetsController.getImage(string2);
            if (image == null) {
                string2 = string + "_" + ResourcesDataControl.leadingZeros(n) + ".png";
                image = AssetsController.getImage(string2);
            }
            if (image == null) {
                bl2 = true;
            } else if (!bl) {
                animation.addFrame(-1, new Frame(animation.getImageLoaderFactory(), string2));
            } else {
                animation.addFrame(-1, new Frame(animation.getImageLoaderFactory(), string2, 100L, true));
            }
            ++n;
        }
    }

    private static String leadingZeros(int n) {
        String string = n < 10 ? "0" : "";
        string = string + n;
        return string;
    }

    public String getName() {
        return this.resources.getName();
    }

    public void changeAssetPath(int n, String string) {
        this.resources.deleteAsset(this.assetsInformation[n].name);
        this.resources.addAsset(this.assetsInformation[n].name, string);
    }

    public void addAsset(String string, String string2) {
        this.resources.addAsset(string, string2);
    }

    public AssetInformation[] getAssetsInformation() {
        return this.assetsInformation;
    }
}

