/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ExitLookDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeNSDestinyPositionTool;
import es.eucm.eadventure.editor.control.tools.general.ChangeTransitionTimeTool;
import es.eucm.eadventure.editor.control.tools.general.ChangeTransitionTypeTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.List;

public class NextSceneDataControl
extends DataControl {
    private NextScene nextScene;
    private ConditionsController conditionsController;
    private EffectsController effectsController;
    private EffectsController postEffectsController;
    private ExitLookDataControl exitLookDataController;

    public NextSceneDataControl(NextScene nextScene) {
        this.nextScene = nextScene;
        this.conditionsController = new ConditionsController(nextScene.getConditions());
        this.effectsController = new EffectsController(nextScene.getEffects());
        this.postEffectsController = new EffectsController(nextScene.getPostEffects());
        this.exitLookDataController = new ExitLookDataControl(nextScene);
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    public EffectsController getEffects() {
        return this.effectsController;
    }

    public EffectsController getPostEffects() {
        return this.postEffectsController;
    }

    public String getNextSceneId() {
        return this.nextScene.getTargetId();
    }

    public boolean hasDestinyPosition() {
        return this.nextScene.hasPlayerPosition();
    }

    public int getDestinyPositionX() {
        return this.nextScene.getPositionX();
    }

    public int getDestinyPositionY() {
        return this.nextScene.getPositionY();
    }

    public void setNextSceneId(String string) {
        this.controller.addTool(new ChangeTargetIdTool((HasTargetId)this.nextScene, string, true, true));
    }

    public void toggleDestinyPosition() {
        if (this.nextScene.hasPlayerPosition()) {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.nextScene, Integer.MIN_VALUE, Integer.MIN_VALUE));
        } else {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.nextScene, 0, 0));
        }
    }

    public void setDestinyPosition(int n, int n2) {
        this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.nextScene, n, n2));
    }

    @Override
    public Object getContent() {
        return this.nextScene;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.nextScene.getConditions());
        EffectsController.updateVarFlagSummary(varFlagSummary, this.nextScene.getEffects());
        EffectsController.updateVarFlagSummary(varFlagSummary, this.nextScene.getPostEffects());
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.Effects"), list, this.nextScene.getEffects());
        return bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.PostEffects"), list, this.nextScene.getPostEffects());
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        n += EffectsController.countAssetReferences(string, this.nextScene.getEffects());
        return n += EffectsController.countAssetReferences(string, this.nextScene.getPostEffects());
    }

    @Override
    public void deleteAssetReferences(String string) {
        EffectsController.deleteAssetReferences(string, this.nextScene.getEffects());
        EffectsController.deleteAssetReferences(string, this.nextScene.getPostEffects());
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (this.nextScene.getTargetId().equals(string)) {
            ++n;
        }
        n += EffectsController.countIdentifierReferences(string, this.nextScene.getEffects());
        return n += EffectsController.countIdentifierReferences(string, this.nextScene.getPostEffects());
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.nextScene.getTargetId().equals(string)) {
            this.nextScene.setTargetId(string2);
        }
        EffectsController.replaceIdentifierReferences(string, string2, this.nextScene.getEffects());
        EffectsController.replaceIdentifierReferences(string, string2, this.nextScene.getPostEffects());
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        EffectsController.deleteIdentifierReferences(string, this.nextScene.getEffects());
        EffectsController.deleteIdentifierReferences(string, this.nextScene.getPostEffects());
    }

    public ExitLookDataControl getExitLookDataController() {
        return this.exitLookDataController;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        if (this.nextScene.getEffects() != null) {
            EffectsController.getAssetReferences(list, list2, this.nextScene.getEffects());
        }
        if (this.nextScene.getPostEffects() != null) {
            EffectsController.getAssetReferences(list, list2, this.nextScene.getPostEffects());
        }
        if (this.exitLookDataController != null) {
            this.exitLookDataController.getAssetReferences(list, list2);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.conditionsController, TC.get((String)"Search.Conditions"));
        this.check(this.getNextSceneId(), TC.get((String)"Search.NextScene"));
    }

    public int getTransitionType() {
        return this.nextScene.getTransitionType();
    }

    public Number getTransitionTime() {
        return this.nextScene.getTransitionTime();
    }

    public void setTransitionTime(int n) {
        Controller.getInstance().addTool(new ChangeTransitionTimeTool(this.nextScene, n));
    }

    public void setTransitionType(int n) {
        Controller.getInstance().addTool(new ChangeTransitionTypeTool(this.nextScene, n));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

