/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.general.InvalidExitCursorTool;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectExitCursorPathTool;
import java.util.List;

public class ExitLookDataControl {
    private ExitLook exitLook;

    public ExitLookDataControl(NextScene nextScene) {
        if (nextScene.getExitLook() == null) {
            nextScene.setExitLook(new ExitLook());
        }
        this.exitLook = nextScene.getExitLook();
    }

    public ExitLookDataControl(Exit exit) {
        if (exit.getDefaultExitLook() == null) {
            exit.setDefaultExitLook(new ExitLook());
        }
        this.exitLook = exit.getDefaultExitLook();
    }

    public boolean isTextCustomized() {
        return this.exitLook.getExitText() != null;
    }

    public String getCustomizedText() {
        String string = null;
        if (this.exitLook != null && this.exitLook.getExitText() != null) {
            string = this.exitLook.getExitText();
        }
        return string;
    }

    public boolean isCursorCustomized() {
        return this.exitLook.getCursorPath() != null;
    }

    public String getCustomizedCursor() {
        String string = null;
        if (this.exitLook != null && this.exitLook.getCursorPath() != null) {
            string = this.exitLook.getCursorPath();
        }
        return string;
    }

    public void setExitText(String string) {
        this.exitLook.setExitText(string);
    }

    public void editCursorPath() {
        try {
            Controller.getInstance().addTool(new SelectExitCursorPathTool(this.exitLook));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public void invalidCursor() {
        Controller.getInstance().addTool(new InvalidExitCursorTool(this.exitLook));
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        if (this.isCursorCustomized()) {
            boolean bl = true;
            for (String string : list) {
                if (!string.equals(this.exitLook.getCursorPath())) continue;
                bl = false;
                break;
            }
            if (bl) {
                int n = list.size();
                list.add(n, this.exitLook.getCursorPath());
                list2.add(n, 6);
            }
        }
    }

    public int countAssetReferences(String string) {
        if (this.exitLook.getCursorPath() != null && this.exitLook.getCursorPath().equals(string)) {
            return 1;
        }
        return 0;
    }

    public void deleteAssetReferences(String string) {
        if (this.exitLook.getCursorPath() != null && this.exitLook.getCursorPath().equals(string)) {
            this.exitLook.setCursorPath("");
        }
    }

    public void setCursorPath(String string) {
        this.exitLook.setCursorPath(string);
    }
}

